/*
 * AndFHEM - Open Source Android application to control a FHEM home automation
 * server.
 *
 * Copyright (c) 2012, Matthias Klass or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU GENERAL PUBLICLICENSE, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU GENERAL PUBLIC LICENSE
 * for more details.
 *
 * You should have received a copy of the GNU GENERAL PUBLIC LICENSE
 * along with this distribution; if not, write to:
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor
 */

package li.klass.fhem.appwidget.view.widget.medium;

import android.content.Context;
import android.widget.RemoteViews;
import li.klass.fhem.R;
import li.klass.fhem.appwidget.WidgetConfiguration;
import li.klass.fhem.appwidget.annotation.WidgetMediumLine1;
import li.klass.fhem.appwidget.annotation.WidgetMediumLine2;
import li.klass.fhem.appwidget.annotation.WidgetMediumLine3;
import li.klass.fhem.appwidget.view.widget.AppWidgetView;
import li.klass.fhem.domain.core.Device;

import static li.klass.fhem.util.ReflectionUtil.getValueAndDescriptionForAnnotation;

public class MediumInformationWidgetView extends AppWidgetView {
    @Override
    public int getWidgetName() {
        return R.string.widget_information;
    }

    @Override
    protected int getContentView() {
        return R.layout.appwidget_information_medium;
    }

    @Override
    protected void fillWidgetView(Context context, RemoteViews view, Device<?> device, WidgetConfiguration widgetConfiguration) {
        String line1 = getValueAndDescriptionForAnnotation(device, WidgetMediumLine1.class);
        String line2 = getValueAndDescriptionForAnnotation(device, WidgetMediumLine2.class);
        String line3 = getValueAndDescriptionForAnnotation(device, WidgetMediumLine3.class);

        setTextViewOrHide(view, R.id.line1, line1);
        setTextViewOrHide(view, R.id.line2, line2);
        setTextViewOrHide(view, R.id.line3, line3);

        openDeviceDetailPageWhenClicking(R.id.main, view, device, widgetConfiguration);
    }
}
