# GrowTracker

Welcome to grow tracker. This is a utility app designed for gardening and tracking various parameters of your grow.

[![Latest Nightly](https://travis-ci.com/7LPdWcaW/GrowTracker-Android.svg?branch=alpha)](https://travis-ci.com/7LPdWcaW/GrowTracker-Android)

[Latest Nightly Build (Experimental!)](https://github.com/7LPdWcaW/GrowTracker-Android/releases/tag/alpha)

[Latest APK: (SHA256) 501786b7350eceb7b894a5745c06c378f1d2f2e6f4bf659ee2576b3dfaca5732 v2.6.1](https://github.com/7LPdWcaW/GrowTracker-Android/releases/download/v2.6.1/v2.6.1-production.apk)

[Latest APK (English only): (SHA256) e366c67c54548da4c46206c953e8847ba6e4c933449ca8d33525601ee2d87bb8 v2.6.1](https://github.com/7LPdWcaW/GrowTracker-Android/releases/download/v2.6.1/v2.6.1-en.apk)

[Latest APK (Discrete): (SHA256) 3b5edaceb462c6fcd51d11652943357976f75b53dacdfe650f422933357688d9 v2.6.1](https://github.com/7LPdWcaW/GrowTracker-Android/releases/download/v2.6.1/v2.6.1-discrete.apk)

[Get it on F-Droid with automatic updates](https://f-droid.org/packages/me.anon.grow/)

You can follow development, post questions, or grow logs in the [Subreddit](https://reddit.com/r/growutils)

# Installation

The app requires no permissions except for external storage (for caching plant data and images) which you can see [here](https://github.com/7LPdWcaW/GrowTracker-Android/blob/develop/app/src/main/AndroidManifest.xml) in order for users to maintain anonymity, and a minimum Android version of `4.2` and above

## How to install from APK

1. Follow [this guide](http://www.inbox.com/article/how-do-enable-third-party-apps-on-android.html) to enable unknown sources
2. Download the APK from [here](https://github.com/7LPdWcaW/GrowTracker-Android/releases)
3. Click on downloaded app and install

## Updating

You can either elect to update manually, or get notified on releases by installing the [Update plugin](https://github.com/7LPdWcaW/GrowUpdater-Android/releases)

**For updates, do not uninstall first, you will lose your existing plant data. Always back up your data!**

# Screenshots

[![install](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/install.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/install.png)
[![main plant list](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/1.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/1.png)
[![plant details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/2.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/2.png)
[![plant photos](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/3.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/3.png)
[![plant actions](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/4.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/4.png)
[![plant statistics](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/5.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/5.png)
[![schedule details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/6.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/6.png)
[![schedule dates](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/7.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/7.png)
[![watering details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/8.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/8.png)
[![garden tracker](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/9.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/9.png)
[![dark main plant list](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/1b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/1b.png)
[![dark plant details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/2b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/2b.png)
[![dark plant photos](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/3b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/3b.png)
[![dark plant actions](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/4b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/4b.png)
[![dark plant statistics](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/5b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/5b.png)
[![dark schedule details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/6b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/6b.png)
[![dark schedule dates](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/7b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/7b.png)
[![dark watering details](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/8b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/8b.png)
[![dark garden tracker](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/9b.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/9b.png)
[![settings](fastlane/metadata/android/en-GB/images/phoneScreenshotsThumbs/10.png)](fastlane/metadata/android/en-GB/images/phoneScreenshots/10.png)

# About the app

The app was designed with data in mind. All data is easily accessible via the app's files folder in `Android/data/me.anon.grow/files/`. You will need a file explorer to browse this folder, or alternatively, you can back your data up via the app settings which will create copies in `backups/GrowTracker/`

The structure is very simple, and consists of a few different objects.

*Note*: date timestamps are all unix timestamps from 1/1/1970 in milliseconds. All objects in arrays are in date order, where index 0 is the oldest and index (size - 1) is the newest.

## Plant object

- `plantDate` in milliseconds
- `images` is an array of file paths. Image file names are the taken date as unix timestamp in milliseconds

```js
{
    "id": <String>,
    "actions": [<Action>],
    "images": [<String>],
    "name": <String>,
    "strain": <String>,
    "clone": <Boolean>,
    "medium": <Medium>,
    "mediumDetails": <String>,
    "plantDate": 1234567890
}
```

### Medium (ENUM)

One of,

`SOIL`, `HYDRO`, `COCO`, `AERO`

## Actions

All actions have the following 3 properties

```js
{
    "type": <String>,
    "date": 1234567890,
    "notes": <String>,
}
```

Only the following actions are currently supports

### Action object (type = Water)

- Temperature measured in ºC
- Amount measured in ml
- Date is milliseconds
- Notes as string

Water action for waterings

```js
{
    "additives": [<Additive>],
    "ph": <Double>,
    "tds": <Tds>,
    "runoff": <Double>,
    "amount": <Double>,
    "date": 1234567890,
    "type": "Water",
    "temp": <Double>,
    "notes": <String>
}
```

### Additive object

- Amount is measured in ml

Object for nutrient dosages

```js
{
    "description": <String>,
    "amount": <Double>
}
```

### Tds object

Object for measuring conductivity or PPM

```js
{
    "amount": <Double>,
    "type": <TdsUnit>
}
```

### Tds Unit (ENUM)

One of,

`PPM500`, `PPM700`, `EC`

### Action object (type = Action)

- Date in milliseconds

Action object for recording plant actions such as trimming, transplanting.

```js
{
    "action": <Action>,
    "date": 1234567890,
    "type": "Action",
    "notes": <String>
}
```

### Action (ENUM)

One of,

`FIM`, `FLUSH`, `FOLIAR_FEED`, `LST`, `LOLLIPOP`, `PESTICIDE_APPLICATION`, `TOP`, `TRANSPLANTED`, `TRIM`, `TUCK`

### Stage change (type = StageChange)

- Date in milliseconds

Action object for recording a change in plant stage.

```js
{
    "newStage": <PlantStage>,
    "date": 1234567890,
    "type": "StageChange",
    "notes": <String>
}
```

### PlantStage (ENUM)

One of,

`PLANTED`, `GERMINATION`, `SEEDLING`, `CUTTING`, `VEGETATION`, `FLOWER`, `DRYING`, `CURING`, `HARVESTED`

### Note action (type = Note)

- Date in milliseconds

```js
{
    "notes": <String>,
    "date": 1234567890,
    "type": "Note"
}
```

## Garden object

The garden object is similar to the plant object, and accepts `Action` types, but is software-restricted to the following

```js
{
    "id": <String>,
    "name": <String>,
    "plantIds": [<String>],
    "actions": [<Action>]
}
```

### Temperature change action (type = TemperatureChange)

- Temperature measured in ºC
- Date in milliseconds

```js
{
    "temp": <Double>,
    "notes": <String>,
    "date": 1234567890,
    "type": "TemperatureChange"
}
```

### Humidity change action (type = HumidityChange)

- Date in milliseconds

```js
{
    "humidity": <Double>,
    "notes": <String>,
    "date": 1234567890,
    "type": "HumidityChange"
}
```

### Light schedule change action (type = LightingChange)

- `on` time format `HH:mm`
- `off` time format `HH:mm`
- Date in milliseconds

```js
{
    "on": <String>,
    "off": <String>,
    "notes": <String>,
    "date": 1234567890,
    "type": "LightingChange"
}
```

# Encryption

Note that this is **not** a guaranteed form of protection from law enforcement agencies.

Encryption in the app uses basic AES for encryption using a provided passphrase. If the passphrase is less than 128 bits (16 UTF-8 chars), it will be padded with `0x0` bytes. You can view the key generator method [here](https://github.com/7LPdWcaW/GrowTracker-Android/blob/master/app/src/main/java/me/anon/lib/helper/EncryptionHelper.java#L27)

You can decrypt your files using your passphrase either by writing a script that uses AES decryption, or an online tool such as [Online-Domain-Tools](http://aes.online-domain-tools.com/).

# Translators

Translations provided by;

- Chinese (Taiwan) - ![TW - Chinese (Taiwan)](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/zh_TW/translated.png); Chief Ndora (chiefndora), codecyang
- Dutch - ![NL - Dutch](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/nl_NL/translated.png); Heimen Stoffels (Vistaus)
- French - ![FR - French](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/fr/translated.png); Maxtille, yassine azirem (yassix.well)
- German - ![DE - German](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/de_DE/translated.png); Acrylic Boy, Alex (Noxmiles), Basti B (Weltenesche), Patrick B (EukalyptusX), Sascha Zenglein (szenglein), Vexatos, W Q (williq)
- Hungarian - ![HU - Hungarian](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/hu/translated.png);
- Norwegian Bokmål - ![NB - Norwegian Bokmål](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/nb/translated.png); Syver Stensholt (SuperPotato)
- Russian - ![RU - Russian](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/ru/translated.png); 9YbQiuEohUu1
- Slovenian - ![SI - Slovenian](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/sl_SI/translated.png); Klemen Skerbiš (aha999)
- Spanish - ![ES - Spanish](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/es/translated.png); EmmanuelMess, Raul Choque (choqueraul123)
- Ukranian - ![UK - Ukrainian](https://transifex-open-api.herokuapp.com/badge/growutils/project/growtracker/language/uk/translated.png); 9YbQiuEohUu1


See [more](https://github.com/7LPdWcaW/GrowTracker-Android/issues/116) about translating GrowTracker

# License

Copyright 2014-2019 7LPdWcaW

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
