package me.anon.lib.helper;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;

import java.net.URISyntaxException;

public class PathHelper
{
	/*
	 * Gets the file path of the given Uri.
	 */
	@SuppressLint("NewApi")
	public static String getPath(Context context, Uri uri) throws URISyntaxException
	{
		final boolean needToCheckUri = Build.VERSION.SDK_INT >= 19;
		String selection = null;
		String[] selectionArgs = null;

		// Uri is different in versions after KITKAT (Android 4.4), we need to
		// deal with different Uris.
		if (needToCheckUri && DocumentsContract.isDocumentUri(context.getApplicationContext(), uri))
		{
			if (isExternalStorageDocument(uri))
			{
				final String docId = DocumentsContract.getDocumentId(uri);
				final String[] split = docId.split(":");

				if ("primary".equalsIgnoreCase(split[0]))
				{
					try
					{
						return Environment.getExternalStorageDirectory() + "/" + split[1];
					}
					catch (ArrayIndexOutOfBoundsException e)
					{
						return Environment.getExternalStorageDirectory() + "/";
					}
				}

				return "/storage/" + TextUtils.join("/", split);
			}
			else if (isDownloadsDocument(uri))
			{
				final String id = DocumentsContract.getDocumentId(uri);
				if (!TextUtils.isEmpty(id))
				{
					if (id.startsWith("raw:"))
					{
						return id.replaceFirst("raw:", "");
					}
					try
					{
						final Uri contentUri = ContentUris.withAppendedId(Uri.parse("content://downloads/public_downloads"), Long.valueOf(id));
						return getDataColumn(context, contentUri, null, null);
					}
					catch (NumberFormatException e)
					{
						return null;
					}
				}
			}
			else if (isMediaDocument(uri))
			{
				final String docId = DocumentsContract.getDocumentId(uri);
				final String[] split = docId.split(":");
				final String type = split[0];
				if ("image".equals(type))
				{
					uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
				}
				else if ("video".equals(type))
				{
					uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
				}
				else if ("audio".equals(type))
				{
					uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
				}

				selection = "_id=?";
				selectionArgs = new String[]{split[1]};
			}
		}
		if ("content".equalsIgnoreCase(uri.getScheme()))
		{
			String[] projection = {MediaStore.Images.Media.DATA};
			Cursor cursor = null;
			try
			{
				cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
				int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
				if (cursor.moveToFirst())
				{
					return cursor.getString(column_index);
				}
			}
			catch (Exception e)
			{
			}
		}
		else if ("file".equalsIgnoreCase(uri.getScheme()))
		{
			return uri.getPath();
		}

		return null;
	}


	/**
	 * @param uri The Uri to check.
	 *
	 * @return Whether the Uri authority is ExternalStorageProvider.
	 */
	public static boolean isExternalStorageDocument(Uri uri)
	{
		return "com.android.externalstorage.documents".equals(uri.getAuthority());
	}

	/**
	 * @param uri The Uri to check.
	 *
	 * @return Whether the Uri authority is DownloadsProvider.
	 */
	public static boolean isDownloadsDocument(Uri uri)
	{
		return "com.android.providers.downloads.documents".equals(uri.getAuthority());
	}

	/**
	 * @param uri The Uri to check.
	 *
	 * @return Whether the Uri authority is MediaProvider.
	 */
	public static boolean isMediaDocument(Uri uri)
	{
		return "com.android.providers.media.documents".equals(uri.getAuthority());
	}

	public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs)
	{
		Cursor cursor = null;
		final String column = "_data";
		final String[] projection = {column};
		try
		{
			cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
			if (cursor != null && cursor.moveToFirst())
			{
				final int index = cursor.getColumnIndexOrThrow(column);
				return cursor.getString(index);
			}
		}
		finally
		{
			if (cursor != null)
			{
				cursor.close();
			}
		}
		return null;
	}
}
