# Projects using Oboe or AAudio

Want your project added? [Add a comment to issue #214](https://github.com/google/oboe/issues/214) with 
your project name and Play Store URL. 

## Frameworks

### JUCE
JUCE has enabled Oboe as an experimental feature.
[JUCE middleware framework](https://juce.com/)

## Apps and Projects
In alphabetical order.

### Best Piano
Learn to play the Piano. Note that they open the stream with 44100 Hz so it will not get an MMAP stream on Pixel.

[App on Play Store](https://play.google.com/store/apps/details?id=com.netigen.piano)

### CSound for Android.
Uses Oboe.

[App on Play Store](https://play.google.com/store/apps/details?id=com.csounds.Csound6),
[Source](https://github.com/gogins/csound-extended/blob/develop/CsoundForAndroid/CsoundAndroid/jni/csound_oboe.hpp)

### G-Stomper apps
Uses AAudio if you enable it in Settings.
- Click "SETUP" button at far right.
- Select "AUD" tab.
- Under "Audio System", select "AAudio".
- Hit Back icon.
- You will see a message saying to restart GStomper.
- Restart GStomper. It should now be using AAudio.

[planet-h.com apps on Play store](https://play.google.com/store/apps/dev?id=5200192441928542082)

### ktnes
A NES emulator implemented in Kotlin using multiplatform support and Kotlin/Native.

[Source](https://github.com/felipecsl/ktnes)

### Les Talens Lyriques
A series of music education apps using Oboe. Note that they open the stream with 44100 Hz so it will not get an MMAP stream on Pixel.

[App on Play Store](https://play.google.com/store/apps/developer?id=Les+Talens+Lyriques)

## Music Speed Changer
Play song files while changing the pitch and tempo.

[App on Play Store](https://play.google.com/store/apps/details?id=com.smp.musicspeed)

### n-Track Studio
Uses AAudio if you enable it in Settings.
- Click menu icon at bottom right.
- Click "Settings".
- Select AAudio for input and/or output.
- Scroll down and click "OK".

[App on Play Store](https://play.google.com/store/apps/details?id=com.ntrack.studio.demo)

### Serial communication via audio on Android
[David Wehr blog](https://davidawehr.com/blog/audioserial/)

### Volcano Mobile
They have several MIDI synthesizer apps using Oboe.

FluidSynth - [App on Play Store](https://play.google.com/store/apps/details?id=net.volcanomobile.fluidsynthmidi)

OPL3 MIDI Synth FM - [App on Play Store](https://play.google.com/store/apps/details?id=net.volcanomobile.opl3midisynth)

MIDI Sequencer app is very handy for testing. [App on Play Store](https://play.google.com/store/apps/details?id=net.volcanomobile.midisequencer)
