import "package:flutter/material.dart";
import "dart:io" as dio;
import "dart:ui" as dui;

import "../Common/Settings.dart";

class ClueData
{
    void Function() redrawFunc = null;

    dio.File file = null;
    Size imgDim = null;

    bool canSnip = false;
    Offset snipPos = null;
    Size snipDim = null;

    ClueData () {}

    bool isLoaded() { return (file != null && imgDim != null); }
    bool isSnip() { return (canSnip && snipPos != null && snipDim != null); }

    void setCanSnip(bool newVal) {
        canSnip = newVal;
        Settings.setBool(ThingToSave.Snip, newVal);

        if(redrawFunc != null)
            redrawFunc();
    }

    void setSnip(Offset tl, Size dim) {
        snipPos = tl;
        snipDim = dim;

        if(redrawFunc != null)
            redrawFunc();
    }

    void clearSnip() {
        snipPos = null;
        snipDim = null;

        if(redrawFunc != null)
            redrawFunc();
    }

    String filePath() { return ((file == null) ? "" : file.path); }

    FractionalOffset snipToPos(BuildContext ctx) { return FractionalOffset(snipPos.dx / (MediaQuery.of(ctx).size.width - snipDim.width), snipPos.dy / (height(ctx) - snipDim.height)); }

    double height(BuildContext ctx) { return imgDim.height * MediaQuery.of(ctx).size.width / imgDim.width; }

    void loadFromData(String filePath, void Function() onFail) async {
        if(filePath != "") {
            file = dio.File(filePath);
            if(file != null) {
                dui.Image decodedImage = await decodeImageFromList(file.readAsBytesSync());
                imgDim = Size(1.0 * decodedImage.width, 1.0 * decodedImage.height);
            }
            else
                onFail();
        }

        clearSnip();
    }
}