import "package:flutter/material.dart";
import "package:file_picker/file_picker.dart" as pfp;
import "dart:ui" as dui;

import "../Common/ToggleButton.dart";

import "ClueData.dart";

class ClueScreenWidget extends StatefulWidget
{
    final ClueData clue;

    ClueScreenWidget ({ Key key, this.clue }) : super(key: key) {}
    ClueScreenWidgetState createState() { return ClueScreenWidgetState(clue); }
}

class ClueScreenWidgetState extends State<ClueScreenWidget>
{
    bool loadingFile_ = false;
    ClueData clue_;

    Offset holdDragStartPos_ = null;
    Offset dragStartPos_ = null;
    Offset dragEndPos_ = null;

    ClueScreenWidgetState (this.clue_) {
        if(clue_.snipPos != null && clue_.snipDim != null) {
            dragStartPos_ = clue_.snipPos;
            dragEndPos_ = Offset(clue_.snipPos.dx + clue_.snipDim.width, clue_.snipPos.dy + clue_.snipDim.height);
        }
    }

    Widget build(BuildContext ctx) {
        if(!clue_.isLoaded())
            return ToggleButtonWidget(Text("Load Image"), 1.0, h: MediaQuery.of(ctx).size.height, onPress: loadClues);
        else {
            return ListView(children: [
                ToggleButtonWidget(Text("Load New Image"), 1.0, h: 48.0, onPress: loadClues),
                CheckboxListTile(
                    value: clue_.canSnip, onChanged: (bool newVal) { setState(() { clue_.setCanSnip(newVal); }); },
                    title: Text("Enable Snips")
                ),
                (clue_.isSnip()
                    ? ToggleButtonWidget(Text("Clear Snip"), 1.0, h: 48.0, onPress: clearSnip)
                    : Container()
                ),
                (clue_.canSnip
                    ? GestureDetector(
                        child: clueImg(ctx),
                        onTapDown: maybeStartDrag,
                        onPanStart: startDrag,
                        onPanUpdate: updateDrag,
                        onPanEnd: (DragEndDetails details) { stopDrag(details, ctx); }
                    )
                    : clueImg(ctx)
                )
            ]);
        }
    }

    void loadClues() async {
        if(!loadingFile_) {
            loadingFile_ = true;
            clue_.file = await pfp.FilePicker.getFile(type: pfp.FileType.image);

            if(clue_.file != null) {
                dui.Image decodedImage = await decodeImageFromList(clue_.file.readAsBytesSync());
                clue_.imgDim = Size(1.0 * decodedImage.width, 1.0 * decodedImage.height);
            }

            setState(() { loadingFile_ = false; });
        }
    }

    Widget clueImg(BuildContext ctx) {
        return Container(
            width: MediaQuery.of(ctx).size.width, height: clue_.height(ctx),
            decoration: BoxDecoration(
                image: DecorationImage(image: FileImage(clue_.file), fit: BoxFit.fitWidth),
                border: genSnipOverlay(ctx)
            )
        );
    }

    void clearSnip() {
        clue_.clearSnip();
        dragStartPos_ = null;
        dragEndPos_ = null;

        setState(() {});
    }

    void maybeStartDrag(TapDownDetails details) { holdDragStartPos_ = details.localPosition; }

    void startDrag(DragStartDetails details) {
        if(holdDragStartPos_ == null)
            setState(() { dragStartPos_ = details.localPosition; dragEndPos_ = details.localPosition; });
        else
            setState(() { dragStartPos_ = holdDragStartPos_; dragEndPos_ = details.localPosition; holdDragStartPos_ = null; });
    }

    void updateDrag(DragUpdateDetails details) { setState(() { dragEndPos_ = details.localPosition; }); }

    void stopDrag(DragEndDetails details, BuildContext ctx) {
        clue_.setSnip(Offset(snip_l(0), snip_u(0)), Size(snip_r(MediaQuery.of(ctx).size.width) - snip_l(0), snip_d(clue_.height(ctx)) - snip_u(0)));
        setState(() {});
    }

    double snip_u(double min) { double oup = ((dragStartPos_.dy < dragEndPos_.dy) ? dragStartPos_.dy : dragEndPos_.dy); return ((oup < min) ? min : oup); }
    double snip_r(double max) { double oup = ((dragStartPos_.dx < dragEndPos_.dx) ? dragEndPos_.dx : dragStartPos_.dx); return ((oup > max) ? max : oup); }
    double snip_d(double max) { double oup = ((dragStartPos_.dy < dragEndPos_.dy) ? dragEndPos_.dy : dragStartPos_.dy); return ((oup > max) ? max : oup); }
    double snip_l(double min) { double oup = ((dragStartPos_.dx < dragEndPos_.dx) ? dragStartPos_.dx : dragEndPos_.dx); return ((oup < min) ? min : oup); }

    Border genSnipOverlay(BuildContext ctx) {
        if(dragStartPos_ == null || dragEndPos_ == null || !clue_.canSnip)
            return Border();
        else {
            return Border(
                top: BorderSide(color: Color(0x88000000), width: snip_u(0)),
                bottom: BorderSide(color: Color(0x88000000), width: clue_.height(ctx) - snip_d(clue_.height(ctx))),
                left: BorderSide(color: Color(0x88000000), width: snip_l(0)),
                right: BorderSide(color: Color(0x88000000), width: MediaQuery.of(ctx).size.width - snip_r(MediaQuery.of(ctx).size.width))
            );
        }
    }
}