import "package:flutter/material.dart";

import "../Common/ToggleButton.dart";

import "GridData.dart";
import "GridSymmetry.dart";

import "EditGrid.dart";
import "FillGrid.dart";

class GridScreenWidget extends StatefulWidget
{
    final GridData grid;
    final GridSymmetry gridSym;

    GridScreenWidget ({ Key key, this.grid = null, this.gridSym = null }) : super(key: key) {}
    GridScreenWidgetState createState() { return GridScreenWidgetState(grid, gridSym); }
}

class GridScreenWidgetState extends State<GridScreenWidget>
{
    GridData grid_;
    GridSymmetry gridSym_;

    ScrollController scrollCtrl_;

    GridScreenWidgetState (this.grid_, this.gridSym_) {}

    @override void initState() {
        scrollCtrl_ = ScrollController();
        super.initState();
    }

    @override void dispose() {
        scrollCtrl_.dispose();
        super.dispose();
    }

    Widget build(BuildContext ctx) {
        if(grid_.editMode()) {
            return ListView(children: [
                EditGridWidget(grid: grid_, gridSym: gridSym_),
                ToggleButtonWidget(Text("Fill Grid"), 1.0, h: 48.0, onPress: toggleMode)
            ]);
        }
        else {
            return ListView(children: [
                FillGridWidget(grid: grid_, scrollControl: scrollCtrl_),
                ToggleButtonWidget(Text("Edit Grid"), 1.0, h: 48.0, onPress: toggleMode)
            ], controller: scrollCtrl_);
        }
    }

    void toggleMode() { setState(() { grid_.toggleMode(); }); }
}
