import "package:flutter/material.dart";

import "../Common/ToggleButton.dart";

import "GridData.dart";

import "EditGrid.dart";
import "FillGrid.dart";

class GridScreenWidget extends StatefulWidget
{
    final GridData grid;

    GridScreenWidget (this.grid, { Key key }) : super(key: key) {}
    GridScreenWidgetState createState() { return GridScreenWidgetState(grid); }
}

class GridScreenWidgetState extends State<GridScreenWidget>
{
    GridData grid_;

    GridScreenWidgetState (this.grid_) {}

    Widget build(BuildContext ctx) {
        if(grid_.editMode()) {
            return ListView(children: [
                EditGridWidget(grid_),
                ToggleButtonWidget(Text("Fill Grid"), 1.0, h: 48.0, onPress: toggleMode)
            ]);
        }
        else {
            return ListView(children: [
                FillGridWidget(grid_),
                ToggleButtonWidget(Text("Edit Grid"), 1.0, h: 48.0, onPress: toggleMode)
            ]);
        }
    }

    void toggleMode() { grid_.toggleMode(); setState(() {}); }
}
