package net.aangle.rvclock;

import net.aangle.rvclock.SelectApplicationDialogBuilder.ApplicationSelectListener;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;

public class ExecuteAppPreference extends DialogPreference implements
		ApplicationSelectListener {

	private String mValue;
	private AlertDialog mDialog;

	public ExecuteAppPreference(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public ExecuteAppPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	@Override
	protected Object onGetDefaultValue(TypedArray a, int index) {
		return super.onGetDefaultValue(a, index);
	}

	@Override
	protected void onSetInitialValue(boolean restorePersistedValue,
			Object defaultValue) {
		setProperyValue(restorePersistedValue ? getPersistedString(mValue) : (String) defaultValue);
	}
	
	@Override
    protected void showDialog(Bundle state) {
        Context context = getContext();

        // Create the dialog
        SelectApplicationDialogBuilder builder = new SelectApplicationDialogBuilder(context, this);
        final Dialog dialog = mDialog = builder.create();
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        dialog.setOnDismissListener(this);
        dialog.show();
    }	
	
	@Override
	public Dialog getDialog() {
		return mDialog;
	}
    
	public void setProperyValue(String propValue) {
		if (!propValue.equals(mValue)) {
			mValue = propValue;
			persistString(propValue);
			notifyDependencyChange(shouldDisableDependents());
			notifyChanged();
		}
	}

	public String createPropertyValue(String packageName, String className, String name) {
	    return packageName + "\t" + className + "\t" + name;
	}

    public void onApplicationSelected(String packageName, String className, String name) {
    	String prop = createPropertyValue(packageName, className, name);
    	if (RvClockWidget.DEBUG)
    		Log.d(RvClockWidget.TAG, "Selected application: " + prop);
        setProperyValue(prop);
        //setSummary(name);
    }

}
