/*
    This file is part of RvClock.

    RvClock is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    RvClock is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RvClock.  If not, see <http://www.gnu.org/licenses/>.
    
    raven@acute-angle.net
 */

package net.aangle.rvclock;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.RectF;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.RemoteViews;

public abstract class Painter {
	private static final int BASIC_COLOR_1 = 0xccc7b3;
	private static final int BASIC_COLOR_2 = 0xdb7e43;
	protected static final int FILL_COLOR_LIGHT = 0x70999999;
	protected static final int FILL_COLOR_DARK = 0x90101010;
	protected static final int BORDER_COLOR = 0xA0666666;
	protected static final int HOUR_COLOR = (0xFF << 24) | BASIC_COLOR_1;
	protected static final int MINUTE_COLOR = (0xCF << 24) | BASIC_COLOR_2;
	protected static final int WEEKDAY_COLOR = (0xFF << 24) + BASIC_COLOR_2;
	protected static final int DAY_COLOR = (0xFF << 24) + BASIC_COLOR_1;
	protected static final int MONTH_COLOR = (0xFF << 24) + BASIC_COLOR_1;
	protected boolean drawBg;
	protected int bgColor, hourColor, minColor;
	
	public Painter(Context context, int id) {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
		
		this.drawBg = true;
		switch (Integer.valueOf(prefs.getString("bg_color_" + id, "0"))) {
		case 0:
			drawBg = false;
			break;
		case 1:
			this.bgColor = FILL_COLOR_DARK;
			break;
		case 2:
			this.bgColor = FILL_COLOR_LIGHT;
			break;
		}

		hourColor = prefs.getInt("hour_color_" + id, HOUR_COLOR);
		minColor = prefs.getInt("minute_color_" + id, MINUTE_COLOR);
	}
	
	protected void paintBackground(Canvas c) {
		Paint p = new Paint();
		p.setColor(bgColor);
		p.setAntiAlias(true);
		RectF r = new RectF(10, 0, c.getWidth() - 10, c.getHeight());
		c.drawRoundRect(r, 10, 10, p);
		p.setStyle(Style.STROKE);
		p.setColor(BORDER_COLOR);
		c.drawRoundRect(r, 10, 10, p);
	}

	public abstract void draw(Context context, RemoteViews rv);
	
	public PendingIntent getAlarmClockIntent(int widgetId, Context context) {
		Intent intent = new Intent(Intent.ACTION_MAIN);
		intent.addCategory(Intent.CATEGORY_DEFAULT);
		intent.setData(Uri.parse("widget://" + widgetId));
		intent.setComponent(new ComponentName("com.android.alarmclock", "com.android.alarmclock.AlarmClock"));
		PendingIntent result = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_CANCEL_CURRENT);
		return result;
	}
	
	public PendingIntent getSelfConfigureIntent(int widgetId, Context context) {
		Intent intent = new Intent(RvClockWidget.ACTION_CONFIGURE); //AppWidgetManager.ACTION_APPWIDGET_CONFIGURE);
		//Intent intent = new Intent(AppWidgetManager.ACTION_APPWIDGET_CONFIGURE);
		intent.putExtra(AppWidgetManager.EXTRA_APPWIDGET_ID, widgetId);
		intent.setComponent(new ComponentName(context, RvClockSetupActivity.class));
		intent.setData(Uri.parse("widget://" + widgetId));
		if (RvClockWidget.DEBUG)
			Log.d(RvClockWidget.TAG, "Self-intent: " + intent.toString());
		PendingIntent result = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_CANCEL_CURRENT);
		return result;
	}
}
