/*
    This file is part of RvClock.

    RvClock is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    RvClock is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RvClock.  If not, see <http://www.gnu.org/licenses/>.
    
    raven@acute-angle.net
 */

package net.aangle.rvclock;

import java.text.NumberFormat;
import java.util.Calendar;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Align;
import android.graphics.Paint.Style;
import android.graphics.Typeface;
import android.text.format.Time;
import android.widget.RemoteViews;

public class SquareClockPainter extends Painter {
	
	public SquareClockPainter(Context context, int id) {
		super(context, id);
	}

	private Typeface font;

	public void draw(Context context, RemoteViews rv) {
		Bitmap b = Bitmap.createBitmap(146, 146, Bitmap.Config.ARGB_8888);
		Canvas c = new Canvas(b);

		Time time = new Time();
		time.setToNow();

		this.font = Typeface.createFromAsset(context.getAssets(),
				"PT_Sans-Narrow.ttf");

		Calendar cal = Calendar.getInstance();

		NumberFormat nf = NumberFormat.getInstance();
		nf.setMinimumIntegerDigits(2);

		String hours = nf.format(time.hour);
		String minutes = nf.format(time.minute);
		String wkDay = String.format("%ta", cal).toLowerCase();

		String day = String.format("%td", cal);
		String month = String.format("%tb", cal).toLowerCase();

		if (drawBg)
			paintBackground(c);

		paintHours(c, hours);
		paintMinutes(c, minutes);
		int s = paintDayOfMonth(c, day);
		paintWeekDay(c, wkDay, s);
		paintMonth(c, month, s);

		rv.setImageViewBitmap(R.id.image, b);
	}

	private int paintDayOfMonth(Canvas c, String day) {
		Paint p = new Paint();
		p.setAntiAlias(true);
		p.setTypeface(this.font);
		p.setTextAlign(Align.LEFT);
		//p.setColor(DAY_COLOR);
		p.setColor(hourColor);
		c.save();
		p.setTextSize(20);
		int w = (int) p.measureText(day);
		int s = 25;
		c.drawText(day, s, 120, p);
		p.setStyle(Style.STROKE);
		c.drawLine(s + w + 3, 104, s + w + 3, 138, p);
		c.drawLine(s + w + 4, 104, s + w + 4, 138, p);
		c.restore();
		return s + w + 10;
	}

	private void paintWeekDay(Canvas c, String wkDay, int start) {
		Paint p = new Paint();
		p.setAntiAlias(true);
		p.setTypeface(this.font);
		p.setTextAlign(Align.LEFT);
		//p.setColor(WEEKDAY_COLOR);
		p.setColor(minColor);
		c.save();
		p.setTextSize(20);
		c.drawText(wkDay, start, 138, p);
		c.restore();
	}

	private void paintMonth(Canvas c, String month, int start) {
		Paint p = new Paint();
		p.setAntiAlias(true);
		p.setTypeface(this.font);
		p.setTextAlign(Align.LEFT);
		//p.setColor(MONTH_COLOR);
		p.setColor(hourColor);
		c.save();
		p.setTextSize(20);
		c.drawText(month, start, 120, p);
		c.restore();
	}

	private void paintMinutes(Canvas c, String minutes) {
		Paint p = new Paint();
		p.setAntiAlias(true);
		p.setTypeface(this.font);
		p.setTextAlign(Align.CENTER);
		//p.setColor(MINUTE_COLOR);
		p.setColor(minColor);
		p.setTextSize(80);
		c.save();
		c.translate(5 + 40, 100);
		c.scale(1.2f, 1f);
		c.drawText(minutes.substring(0, 1), 0, 0, p);
		c.restore();
		c.save();
		c.translate(5 + 40 + 51, 100);
		c.scale(1.2f, 1f);
		c.drawText(minutes.substring(1, 2), 0, 0, p);
		c.restore();
	}

	private void paintHours(Canvas c, String hours) {
		Paint p = new Paint();
		p.setAntiAlias(true);
		p.setTypeface(this.font);
		p.setTextAlign(Align.CENTER);
		//p.setColor(HOUR_COLOR);
		p.setColor(hourColor);
		c.save();
		p.setTextSize(80);
		c.translate(5 + 40, 65);
		c.scale(1.2f, 1f);
		c.drawText(hours.substring(0, 1), 0, 0, p);
		c.restore();
		c.save();
		c.translate(5 + 40 + 51, 65);
		c.scale(1.2f, 1f);
		c.drawText(hours.substring(1, 2), 0, 0, p);
		c.restore();
	}	
}
