#!/bin/sh

LOCAL_PATH=`dirname $0`
LOCAL_PATH=`cd $LOCAL_PATH && pwd`

echo "Building autogenerated files"
python --version > /dev/null 2>&1 || { echo "Error: no Python installed" ; exit 1 ; }

cd $LOCAL_PATH/src
python datasrc/compile.py network_source > src/game/generated/protocol.cpp
python datasrc/compile.py network_header > src/game/generated/protocol.h
python datasrc/compile.py client_content_source > src/game/generated/client_data.cpp
python datasrc/compile.py client_content_header > src/game/generated/client_data.h
python datasrc/compile.py server_content_source > src/game/generated/server_data.cpp
python datasrc/compile.py server_content_header > src/game/generated/server_data.h

python scripts/cmd5.py src/engine/shared/protocol.h src/game/generated/protocol.h src/game/tuning.h src/game/gamecore.cpp src/game/generated/protocol.h > src/game/generated/nethash.cpp

echo "Archiving data"
mkdir -p ../AndroidData
zip -r data.zip data *.txt *.cfg >/dev/null
mv -f data.zip ../AndroidData/

exit 0
