#include "SDL_config.h"

#include "SDL_version.h"
#include "SDL_androidinput.h"
#include "SDL_screenkeyboard.h"

void SDL_android_init_keymap(SDLKey *SDL_android_keymap)
{
  int i;
  SDLKey * keymap = SDL_android_keymap;

  for (i=0; i<SDL_arraysize(SDL_android_keymap); ++i)
    SDL_android_keymap[i] = SDL_KEY(UNKNOWN);

  keymap[KEYCODE_UNKNOWN] = SDL_KEY(UNKNOWN);

  keymap[KEYCODE_BACK] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_5));

  keymap[KEYCODE_MENU] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_4));

  keymap[KEYCODE_DPAD_CENTER] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_1));
  keymap[KEYCODE_SEARCH] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_7));

  keymap[KEYCODE_VOLUME_UP] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_2));
  keymap[KEYCODE_VOLUME_DOWN] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_3));
  
  keymap[KEYCODE_HOME] = SDL_KEY(HOME); // Cannot be used in application

  // On some devices pressing Camera key will generate Camera keyevent, but releasing it will generate Focus keyevent.
  keymap[KEYCODE_CAMERA] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_6));
  keymap[KEYCODE_FOCUS] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_KEYCODE_6));

  keymap[KEYCODE_CALL] = SDL_KEY(TAB);

  keymap[KEYCODE_0] = SDL_KEY(0);
  keymap[KEYCODE_1] = SDL_KEY(1);
  keymap[KEYCODE_2] = SDL_KEY(2);
  keymap[KEYCODE_3] = SDL_KEY(3);
  keymap[KEYCODE_4] = SDL_KEY(4);
  keymap[KEYCODE_5] = SDL_KEY(5);
  keymap[KEYCODE_6] = SDL_KEY(6);
  keymap[KEYCODE_7] = SDL_KEY(7);
  keymap[KEYCODE_8] = SDL_KEY(8);
  keymap[KEYCODE_9] = SDL_KEY(9);
  keymap[KEYCODE_STAR] = SDL_KEY(KP_MULTIPLY);
  keymap[KEYCODE_POUND] = SDL_KEY(HASH);

  keymap[KEYCODE_DPAD_UP] = SDL_KEY(UP);
  keymap[KEYCODE_DPAD_DOWN] = SDL_KEY(DOWN);
  keymap[KEYCODE_DPAD_LEFT] = SDL_KEY(LEFT);
  keymap[KEYCODE_DPAD_RIGHT] = SDL_KEY(RIGHT);

  keymap[KEYCODE_SOFT_LEFT] = SDL_KEY(KP_4);
  keymap[KEYCODE_SOFT_RIGHT] = SDL_KEY(KP_6);
  keymap[KEYCODE_ENTER] = SDL_KEY(RETURN);


  keymap[KEYCODE_CLEAR] = SDL_KEY(CLEAR);
  keymap[KEYCODE_A] = SDL_KEY(A);
  keymap[KEYCODE_B] = SDL_KEY(B);
  keymap[KEYCODE_C] = SDL_KEY(C);
  keymap[KEYCODE_D] = SDL_KEY(D);
  keymap[KEYCODE_E] = SDL_KEY(E);
  keymap[KEYCODE_F] = SDL_KEY(F);
  keymap[KEYCODE_G] = SDL_KEY(G);
  keymap[KEYCODE_H] = SDL_KEY(H);
  keymap[KEYCODE_I] = SDL_KEY(I);
  keymap[KEYCODE_J] = SDL_KEY(J);
  keymap[KEYCODE_K] = SDL_KEY(K);
  keymap[KEYCODE_L] = SDL_KEY(L);
  keymap[KEYCODE_M] = SDL_KEY(M);
  keymap[KEYCODE_N] = SDL_KEY(N);
  keymap[KEYCODE_O] = SDL_KEY(O);
  keymap[KEYCODE_P] = SDL_KEY(P);
  keymap[KEYCODE_Q] = SDL_KEY(Q);
  keymap[KEYCODE_R] = SDL_KEY(R);
  keymap[KEYCODE_S] = SDL_KEY(S);
  keymap[KEYCODE_T] = SDL_KEY(T);
  keymap[KEYCODE_U] = SDL_KEY(U);
  keymap[KEYCODE_V] = SDL_KEY(V);
  keymap[KEYCODE_W] = SDL_KEY(W);
  keymap[KEYCODE_X] = SDL_KEY(X);
  keymap[KEYCODE_Y] = SDL_KEY(Y);
  keymap[KEYCODE_Z] = SDL_KEY(Z);
  keymap[KEYCODE_COMMA] = SDL_KEY(COMMA);
  keymap[KEYCODE_PERIOD] = SDL_KEY(PERIOD);
  keymap[KEYCODE_TAB] = SDL_KEY(TAB);
  keymap[KEYCODE_SPACE] = SDL_KEY(SPACE);
  keymap[KEYCODE_DEL] = SDL_KEY(BACKSPACE);
  keymap[KEYCODE_GRAVE] = SDL_KEY(GRAVE);
  keymap[KEYCODE_MINUS] = SDL_KEY(MINUS);
  keymap[KEYCODE_PLUS] = SDL_KEY(PLUS);
  keymap[KEYCODE_EQUALS] = SDL_KEY(EQUALS);
  keymap[KEYCODE_LEFT_BRACKET] = SDL_KEY(LEFTBRACKET);
  keymap[KEYCODE_RIGHT_BRACKET] = SDL_KEY(RIGHTBRACKET);
  keymap[KEYCODE_BACKSLASH] = SDL_KEY(BACKSLASH);
  keymap[KEYCODE_SEMICOLON] = SDL_KEY(SEMICOLON);
  keymap[KEYCODE_APOSTROPHE] = SDL_KEY(APOSTROPHE);
  keymap[KEYCODE_SLASH] = SDL_KEY(SLASH);
  keymap[KEYCODE_AT] = SDL_KEY(AT);

  keymap[KEYCODE_MEDIA_PLAY_PAUSE] = SDL_KEY(KP_2);
  keymap[KEYCODE_MEDIA_STOP] = SDL_KEY(HELP);
  keymap[KEYCODE_MEDIA_NEXT] = SDL_KEY(KP_8);
  keymap[KEYCODE_MEDIA_PREVIOUS] = SDL_KEY(KP_5);
  keymap[KEYCODE_MEDIA_REWIND] = SDL_KEY(KP_1);
  keymap[KEYCODE_MEDIA_FAST_FORWARD] = SDL_KEY(KP_3);
  keymap[KEYCODE_MUTE] = SDL_KEY(KP_0);

  keymap[KEYCODE_SYM] = SDL_KEY(LGUI);
  keymap[KEYCODE_NUM] = SDL_KEY(NUMLOCKCLEAR);

  keymap[KEYCODE_ALT_LEFT] = SDL_KEY(LALT);
  keymap[KEYCODE_ALT_RIGHT] = SDL_KEY(RALT);

  keymap[KEYCODE_SHIFT_LEFT] = SDL_KEY(LSHIFT);
  keymap[KEYCODE_SHIFT_RIGHT] = SDL_KEY(RSHIFT);

  keymap[KEYCODE_EXPLORER] = SDL_KEY(F3);
  keymap[KEYCODE_ENVELOPE] = SDL_KEY(F4);

  keymap[KEYCODE_HEADSETHOOK] = SDL_KEY(F5);
  keymap[KEYCODE_NOTIFICATION] = SDL_KEY(F6);

  // Cannot be received by application, OS internal
  keymap[KEYCODE_ENDCALL] = SDL_KEY(LSHIFT);
  keymap[KEYCODE_POWER] = SDL_KEY(RALT);

  keymap[KEYCODE_PAGE_UP] = SDL_KEY(PAGEUP);
  keymap[KEYCODE_PAGE_DOWN] = SDL_KEY(PAGEDOWN);
  keymap[KEYCODE_PICTSYMBOLS] = SDL_KEY(LSHIFT);
  keymap[KEYCODE_SWITCH_CHARSET] = SDL_KEY(LSHIFT);
  keymap[KEYCODE_BUTTON_A] = SDL_KEY(A);
  keymap[KEYCODE_BUTTON_B] = SDL_KEY(B);
  keymap[KEYCODE_BUTTON_C] = SDL_KEY(C);
  keymap[KEYCODE_BUTTON_X] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_SCREENKB_KEYCODE_0));
  keymap[KEYCODE_BUTTON_Y] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_SCREENKB_KEYCODE_1));
  keymap[KEYCODE_BUTTON_Z] = SDL_KEY(Z);
  keymap[KEYCODE_BUTTON_L1] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_SCREENKB_KEYCODE_2));
  keymap[KEYCODE_BUTTON_R1] = SDL_KEY(SDL_KEY_VAL(SDL_ANDROID_SCREENKB_KEYCODE_3));
  keymap[KEYCODE_BUTTON_L2] = SDL_KEY(LCTRL);
  keymap[KEYCODE_BUTTON_R2] = SDL_KEY(RCTRL);
  keymap[KEYCODE_BUTTON_THUMBL] = SDL_KEY(LALT);
  keymap[KEYCODE_BUTTON_THUMBR] = SDL_KEY(RALT);
  keymap[KEYCODE_BUTTON_START] = SDL_KEY(RETURN);
  keymap[KEYCODE_BUTTON_SELECT] = SDL_KEY(ESCAPE);
  keymap[KEYCODE_BUTTON_MODE] = SDL_KEY(SPACE);
  keymap[KEYCODE_ESCAPE] = SDL_KEY(ESCAPE);
  keymap[KEYCODE_FORWARD_DEL] = SDL_KEY(DELETE);
  keymap[KEYCODE_CTRL_LEFT] = SDL_KEY(LCTRL);
  keymap[KEYCODE_CTRL_RIGHT] = SDL_KEY(RCTRL);
  keymap[KEYCODE_CAPS_LOCK] = SDL_KEY(CAPSLOCK);
  keymap[KEYCODE_SCROLL_LOCK] = SDL_KEY(SCROLLLOCK);
  keymap[KEYCODE_META_LEFT] = SDL_KEY(LEFT);
  keymap[KEYCODE_META_RIGHT] = SDL_KEY(RIGHT);
  keymap[KEYCODE_FUNCTION] = SDL_KEY(RGUI);
  keymap[KEYCODE_SYSRQ] = SDL_KEY(SYSREQ);
  keymap[KEYCODE_BREAK] = SDL_KEY(PAUSE);
  keymap[KEYCODE_MOVE_HOME] = SDL_KEY(HOME);
  keymap[KEYCODE_MOVE_END] = SDL_KEY(END);
  keymap[KEYCODE_INSERT] = SDL_KEY(INSERT);
  keymap[KEYCODE_FORWARD] = SDL_KEY(RIGHT);
  keymap[KEYCODE_MEDIA_PLAY] = SDL_KEY(F1);
  keymap[KEYCODE_MEDIA_PAUSE] = SDL_KEY(F2);
  keymap[KEYCODE_MEDIA_CLOSE] = SDL_KEY(F3);
  keymap[KEYCODE_MEDIA_EJECT] = SDL_KEY(F4);
  keymap[KEYCODE_MEDIA_RECORD] = SDL_KEY(F5);
  keymap[KEYCODE_F1] = SDL_KEY(F1);
  keymap[KEYCODE_F2] = SDL_KEY(F2);
  keymap[KEYCODE_F3] = SDL_KEY(F3);
  keymap[KEYCODE_F4] = SDL_KEY(F4);
  keymap[KEYCODE_F5] = SDL_KEY(F5);
  keymap[KEYCODE_F6] = SDL_KEY(F6);
  keymap[KEYCODE_F7] = SDL_KEY(F7);
  keymap[KEYCODE_F8] = SDL_KEY(F8);
  keymap[KEYCODE_F9] = SDL_KEY(F9);
  keymap[KEYCODE_F10] = SDL_KEY(F10);
  keymap[KEYCODE_F11] = SDL_KEY(F11);
  keymap[KEYCODE_F12] = SDL_KEY(F12);
  keymap[KEYCODE_NUM_LOCK] = SDL_KEY(NUMLOCKCLEAR);
  keymap[KEYCODE_NUMPAD_0] = SDL_KEY(KP_0);
  keymap[KEYCODE_NUMPAD_1] = SDL_KEY(KP_1);
  keymap[KEYCODE_NUMPAD_2] = SDL_KEY(KP_2);
  keymap[KEYCODE_NUMPAD_3] = SDL_KEY(KP_3);
  keymap[KEYCODE_NUMPAD_4] = SDL_KEY(KP_4);
  keymap[KEYCODE_NUMPAD_5] = SDL_KEY(KP_5);
  keymap[KEYCODE_NUMPAD_6] = SDL_KEY(KP_6);
  keymap[KEYCODE_NUMPAD_7] = SDL_KEY(KP_7);
  keymap[KEYCODE_NUMPAD_8] = SDL_KEY(KP_8);
  keymap[KEYCODE_NUMPAD_9] = SDL_KEY(KP_9);
  keymap[KEYCODE_NUMPAD_DIVIDE] = SDL_KEY(KP_DIVIDE);
  keymap[KEYCODE_NUMPAD_MULTIPLY] = SDL_KEY(KP_MULTIPLY);
  keymap[KEYCODE_NUMPAD_SUBTRACT] = SDL_KEY(KP_MINUS);
  keymap[KEYCODE_NUMPAD_ADD] = SDL_KEY(KP_PLUS);
  keymap[KEYCODE_NUMPAD_DOT] = SDL_KEY(KP_PERIOD);
  keymap[KEYCODE_NUMPAD_COMMA] = SDL_KEY(KP_PERIOD);
  keymap[KEYCODE_NUMPAD_ENTER] = SDL_KEY(KP_ENTER);
  keymap[KEYCODE_NUMPAD_EQUALS] = SDL_KEY(KP_EQUALS);
  keymap[KEYCODE_NUMPAD_LEFT_PAREN] = SDL_KEY(KP_DIVIDE);
  keymap[KEYCODE_NUMPAD_RIGHT_PAREN] = SDL_KEY(KP_MULTIPLY);
  keymap[KEYCODE_VOLUME_MUTE] = SDL_KEY(F13);
  keymap[KEYCODE_INFO] = SDL_KEY(F14);
  keymap[KEYCODE_CHANNEL_UP] = SDL_KEY(UP);
  keymap[KEYCODE_CHANNEL_DOWN] = SDL_KEY(DOWN);
  keymap[KEYCODE_ZOOM_IN] = SDL_KEY(PAGEUP);
  keymap[KEYCODE_ZOOM_OUT] = SDL_KEY(PAGEDOWN);
  keymap[KEYCODE_TV] = SDL_KEY(F15);
  keymap[KEYCODE_WINDOW] = SDL_KEY(F1);
  keymap[KEYCODE_GUIDE] = SDL_KEY(F2);
  keymap[KEYCODE_DVR] = SDL_KEY(F3);
  keymap[KEYCODE_BOOKMARK] = SDL_KEY(F4);
  keymap[KEYCODE_CAPTIONS] = SDL_KEY(F5);
  keymap[KEYCODE_SETTINGS] = SDL_KEY(F6);
  keymap[KEYCODE_TV_POWER] = SDL_KEY(F7);
  keymap[KEYCODE_TV_INPUT] = SDL_KEY(F8);
  keymap[KEYCODE_STB_POWER] = SDL_KEY(F9);
  keymap[KEYCODE_STB_INPUT] = SDL_KEY(F10);
  keymap[KEYCODE_AVR_POWER] = SDL_KEY(F11);
  keymap[KEYCODE_AVR_INPUT] = SDL_KEY(F12);
  keymap[KEYCODE_PROG_RED] = SDL_KEY(F13);
  keymap[KEYCODE_PROG_GREEN] = SDL_KEY(F14);
  keymap[KEYCODE_PROG_YELLOW] = SDL_KEY(F15);
  keymap[KEYCODE_PROG_BLUE] = SDL_KEY(F1);
  keymap[KEYCODE_APP_SWITCH] = SDL_KEY(F2);
  keymap[KEYCODE_BUTTON_1] = SDL_KEY(A);
  keymap[KEYCODE_BUTTON_2] = SDL_KEY(B);
  keymap[KEYCODE_BUTTON_3] = SDL_KEY(C);
  keymap[KEYCODE_BUTTON_4] = SDL_KEY(D);
  keymap[KEYCODE_BUTTON_5] = SDL_KEY(E);
  keymap[KEYCODE_BUTTON_6] = SDL_KEY(F);
  keymap[KEYCODE_BUTTON_7] = SDL_KEY(G);
  keymap[KEYCODE_BUTTON_8] = SDL_KEY(H);
  keymap[KEYCODE_BUTTON_9] = SDL_KEY(I);
  keymap[KEYCODE_BUTTON_10] = SDL_KEY(J);
  keymap[KEYCODE_BUTTON_11] = SDL_KEY(K);
  keymap[KEYCODE_BUTTON_12] = SDL_KEY(L);
  keymap[KEYCODE_BUTTON_13] = SDL_KEY(M);
  keymap[KEYCODE_BUTTON_14] = SDL_KEY(N);
  keymap[KEYCODE_BUTTON_15] = SDL_KEY(O);
  keymap[KEYCODE_BUTTON_16] = SDL_KEY(P);

}
