/*
 * Decompiled with CFR 0.152.
 */
package com.revmob;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.revmob.RevMobAdsListener;
import com.revmob.RevMobTestingMode;
import com.revmob.RevMobUserGender;
import com.revmob.ads.banner.RevMobBanner;
import com.revmob.ads.fullscreen.FullscreenActivity;
import com.revmob.ads.fullscreen.RevMobFullscreen;
import com.revmob.ads.link.RevMobLink;
import com.revmob.ads.popup.RevMobPopup;
import com.revmob.android.RevMobContext;
import com.revmob.android.RevMobScreen;
import com.revmob.android.StoredData;
import com.revmob.android.UserInformation;
import com.revmob.client.RevMobClient;
import com.revmob.client.SessionClientListener;
import com.revmob.internal.AndroidHelper;
import com.revmob.internal.RMLog;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevMob {
    protected static RevMob session;

    private static void validateActivity(Activity activity) {
        if (activity == null) {
            throw new RuntimeException("RevMob: Activity must not be a null value.");
        }
    }

    private static void validatePermissions(Activity activity) {
        String msg = "Permission %s is required. Add it to your AndroidManifest.xml file";
        if (!AndroidHelper.isPermissionEnabled((Context)activity, "INTERNET")) {
            RMLog.e(String.format("Permission %s is required. Add it to your AndroidManifest.xml file", "INTERNET"));
        }
        if (!AndroidHelper.isPermissionEnabled((Context)activity, "ACCESS_WIFI_STATE")) {
            RMLog.e(String.format("Permission %s is required. Add it to your AndroidManifest.xml file", "ACCESS_WIFI_STATE"));
        }
        if (!AndroidHelper.isPermissionEnabled((Context)activity, "READ_PHONE_STATE")) {
            RMLog.e(String.format("Permission %s is required. Add it to your AndroidManifest.xml file", "READ_PHONE_STATE"));
        }
    }

    private static void validateFullscreenActivity(Activity activity) {
        if (!FullscreenActivity.isFullscreenActivityAvailable(activity).booleanValue()) {
            RMLog.e("You must declare the RevMob FullscreenActivity in the AndroidManifest.xml file");
        }
    }

    @Deprecated
    public static RevMob start(Activity activity, String appId) {
        if (session == null) {
            RevMob.validatePermissions(activity);
            RevMob.validateActivity(activity);
            RevMob.validateFullscreenActivity(activity);
            session = new RevMob(activity, appId);
        }
        return session;
    }

    public static RevMob start(Activity activity) {
        if (session == null) {
            try {
                ApplicationInfo ai = activity.getPackageManager().getApplicationInfo(activity.getPackageName(), 128);
                String appId = ai.metaData.getString("com.revmob.app.id");
                return RevMob.start(activity, appId);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("You must the the revmob.app.id value in the AndroidManifest.xml file.");
            }
        }
        return session;
    }

    public static RevMob session() {
        if (session == null) {
            RMLog.w("Call RevMobAds.start(activity, APP_ID) on application start/resume. It will help us to improve tracking and increase the eCPM.");
        }
        return session;
    }

    protected RevMob(Activity activity, String appId) {
        RevMob.validateActivity(activity);
        StoredData cache = new StoredData((Context)activity);
        boolean needToRegisterInstall = !cache.isAlreadyTracked();
        SessionClientListener listener = new SessionClientListener(activity, needToRegisterInstall);
        RevMobClient.getInstance().startSession(appId, RevMobContext.toPayload(activity), listener);
        RevMobScreen.load(activity);
    }

    public void showFullscreen(Activity activity) {
        RevMobFullscreen ad = this.createFullscreen(activity, null, null);
        ad.show();
    }

    public void showFullscreen(Activity activity, String placementId) {
        RevMobFullscreen ad = this.createFullscreen(activity, placementId, null);
        ad.show();
    }

    public void showFullscreen(Activity activity, RevMobAdsListener listener) {
        RevMobFullscreen ad = this.createFullscreen(activity, null, listener);
        ad.show();
    }

    public void showFullscreen(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMobFullscreen ad = this.createFullscreen(activity, placementId, listener);
        ad.show();
    }

    public RevMobFullscreen createFullscreen(Activity activity, RevMobAdsListener listener) {
        return this.createFullscreen(activity, null, listener);
    }

    public RevMobFullscreen createFullscreen(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMob.validateActivity(activity);
        RevMobFullscreen ad = new RevMobFullscreen(activity, listener);
        ad.load(placementId);
        return ad;
    }

    public RevMobBanner createBanner(Activity activity) {
        return this.createBanner(activity, null, null);
    }

    public RevMobBanner createBanner(Activity activity, RevMobAdsListener listener) {
        return this.createBanner(activity, null, listener);
    }

    public RevMobBanner createBanner(Activity activity, String placementId) {
        return this.createBanner(activity, placementId, null);
    }

    public RevMobBanner createBanner(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMob.validateActivity(activity);
        RevMobBanner ad = new RevMobBanner(activity, listener);
        ad.load(placementId);
        return ad;
    }

    public void openAdLink(Activity activity, RevMobAdsListener listener) {
        RevMobLink ad = this.createAdLink(activity, null, listener);
        ad.open();
    }

    public void openAdLink(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMobLink ad = this.createAdLink(activity, placementId, listener);
        ad.open();
    }

    public RevMobLink createAdLink(Activity activity, RevMobAdsListener listener) {
        return this.createAdLink(activity, null, listener);
    }

    public RevMobLink createAdLink(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMob.validateActivity(activity);
        RevMobLink ad = new RevMobLink(activity, listener);
        ad.load(placementId);
        return ad;
    }

    public void showPopup(Activity activity) {
        RevMobPopup ad = this.createPopup(activity, null, null);
        ad.show();
    }

    public void showPopup(Activity activity, String placementId) {
        RevMobPopup ad = this.createPopup(activity, placementId, null);
        ad.show();
    }

    public void showPopup(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMobPopup ad = this.createPopup(activity, null, listener);
        ad.show();
    }

    public RevMobPopup createPopup(Activity activity, RevMobAdsListener listener) {
        return this.createPopup(activity, null, listener);
    }

    public RevMobPopup createPopup(Activity activity, String placementId, RevMobAdsListener listener) {
        RevMob.validateActivity(activity);
        RevMobPopup ad = new RevMobPopup(activity, listener);
        ad.load(placementId);
        return ad;
    }

    public void printEnvironmentInformation(Activity activity) {
        RevMob.validateActivity(activity);
        RevMobContext info = new RevMobContext((Context)activity);
        info.printEnvironmentInformation(RevMobClient.getInstance().getAppId());
    }

    public RevMobTestingMode getTestingMode() {
        return RevMobClient.getInstance().getTestingMode();
    }

    public void setTestingMode(RevMobTestingMode testingMode) {
        RevMobClient.getInstance().setTestingMode(testingMode);
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        RevMobClient.getInstance().setTimeoutInSeconds(timeoutInSeconds);
    }

    public void setUserEmail(String email) {
        UserInformation.getInstance().setEmail(email);
    }

    public RevMobUserGender getUserGender() {
        return UserInformation.getInstance().getUserGender();
    }

    public void setUserGender(RevMobUserGender userGender) {
        UserInformation.getInstance().setUserGender(userGender);
    }

    public int getUserAgeRangeMin() {
        return UserInformation.getInstance().getUserAgeRangeMin();
    }

    public void setUserAgeRangeMin(int userAgeRangeMin) {
        UserInformation.getInstance().setUserAgeRangeMin(userAgeRangeMin);
    }

    public int getUserAgeRangeMax() {
        return UserInformation.getInstance().getUserAgeRangeMax();
    }

    public void setUserAgeRangeMax(int userAgeRangeMax) {
        UserInformation.getInstance().setUserAgeRangeMax(userAgeRangeMax);
    }

    public Calendar getUserBirthday() {
        return UserInformation.getInstance().getUserBirthday();
    }

    public void setUserBirthday(Calendar userBirthday) {
        UserInformation.getInstance().setUserBirthday(userBirthday);
    }

    public String getUserPage() {
        return UserInformation.getInstance().getUserPage();
    }

    public void setUserPage(String userPage) {
        UserInformation.getInstance().setUserPage(userPage);
    }

    public List<String> getUserInterests() {
        return UserInformation.getInstance().getUserInterests();
    }

    public void setUserInterests(List<String> userInterests) {
        UserInformation.getInstance().setUserInterests(userInterests);
    }

    public void setUserLocation(double userLatitude, double userLongitude, float userAccuracy) {
        UserInformation.getInstance().setUserLocationLatitude(userLatitude);
        UserInformation.getInstance().setUserLocationLongitude(userLongitude);
        UserInformation.getInstance().setUserLocationAccuracy(userAccuracy);
    }
}

