/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen.client;

import android.graphics.Bitmap;
import android.view.animation.Animation;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.internal.AnimationConfiguration;
import com.revmob.client.AdData;
import java.util.HashMap;
import java.util.Map;

public class FullscreenData
extends AdData {
    public static final String KEY = "com.revmob.ads.fullscreen.adUrl";
    private static Map<String, FullscreenData> loadedFullscreens = new HashMap<String, FullscreenData>();
    private Bitmap imageSquare;
    private Bitmap imagePortrait;
    private Bitmap imageLandscape;
    private String htmlAdUrl;
    private String htmlCode;
    private String dspUrl;
    private String dspHtml;
    private AnimationConfiguration showAnimation;
    private AnimationConfiguration closeAnimation;
    private RevMobAdsListener publisherListener;

    public static void addLoadedFullscreen(FullscreenData ad) {
        loadedFullscreens.put(ad.getClickUrl(), ad);
    }

    public static FullscreenData getLoadedFullscreen(String key) {
        return loadedFullscreens.get(key);
    }

    public static void cleanLoadedFullscreen(FullscreenData ad) {
        if (ad != null) {
            loadedFullscreens.remove(ad.getClickUrl());
        }
    }

    public FullscreenData(String impressionUrl, String clickUrl, RevMobAdsListener publisherListener, String htmlAdUrl, String htmlCode, String dspUrl, String dspHtml, Bitmap imageSquare2, Bitmap imageLandscape2, Bitmap imagePortrait2, AnimationConfiguration showAnimation, AnimationConfiguration closeAnimation, String appOrSite, boolean openInside) {
        super(impressionUrl, clickUrl, appOrSite, openInside);
        this.publisherListener = publisherListener;
        this.htmlCode = htmlCode;
        this.htmlAdUrl = htmlAdUrl;
        this.dspUrl = dspUrl;
        this.dspHtml = dspHtml;
        this.imagePortrait = imagePortrait2;
        this.imageLandscape = imageLandscape2;
        this.imageSquare = imageSquare2;
        this.showAnimation = showAnimation;
        this.closeAnimation = closeAnimation;
    }

    public Bitmap getAdImage(int orientation) {
        if (orientation == 2 && this.imageLandscape != null) {
            return this.imageLandscape;
        }
        if (orientation == 1 && this.imagePortrait != null) {
            return this.imagePortrait;
        }
        return this.imageSquare;
    }

    public boolean isHtmlCodeLoaded() {
        return this.htmlCode != null && this.htmlCode != "";
    }

    public String getHtmlCode() {
        return this.htmlCode;
    }

    public String getHtmlAdUrl() {
        return this.htmlAdUrl;
    }

    public String getDspUrl() {
        return this.dspUrl;
    }

    public String getDspHtml() {
        return this.dspHtml;
    }

    public RevMobAdsListener getPublisherListener() {
        return this.publisherListener;
    }

    public boolean isHtmlFullscreen() {
        return this.htmlAdUrl != null || this.htmlCode != null;
    }

    public boolean isDspFullscreen() {
        return this.dspUrl != null || this.dspHtml != null;
    }

    public boolean isStaticMultiOrientationFullscreen() {
        return this.imagePortrait != null && this.imageLandscape != null;
    }

    public Animation getShowAnimation() {
        return this.showAnimation.getAnimation();
    }

    public Animation getCloseAnimation() {
        return this.closeAnimation.getAnimation();
    }
}

