/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.link;

import android.app.Activity;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdState;
import com.revmob.ads.link.client.LinkClientListener;
import com.revmob.android.RevMobContext;
import com.revmob.client.AdData;
import com.revmob.client.RevMobClient;
import com.revmob.internal.MarketAsyncManager;
import com.revmob.internal.RMLog;

public class RevMobLink
implements Ad {
    private Activity activity;
    private AdData data;
    public boolean autoopen = false;
    private AdState state;
    private RevMobAdsListener publisherListener;

    public RevMobLink(Activity activity, RevMobAdsListener publisherListener) {
        this.activity = activity;
        this.publisherListener = publisherListener;
        this.state = AdState.CREATED;
    }

    public void load() {
        this.load(null);
    }

    public void load(String placementId) {
        if (this.state == AdState.CREATED || this.state == AdState.CLOSED) {
            RMLog.i(placementId != null ? "Loading Link " + placementId : "Loading Link");
            RevMobClient.getInstance().fetchAdLink(placementId, RevMobContext.toPayload(this.activity), new LinkClientListener(this, this.publisherListener));
        }
    }

    public void updateWithData(AdData advertisement) {
        this.state = AdState.LOADED;
        this.data = advertisement;
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdReceived();
        }
        if (this.autoopen) {
            this.open();
        }
    }

    private boolean isLoaded() {
        return this.data != null;
    }

    public void cancel() {
        this.autoopen = false;
    }

    public void open() {
        this.autoopen = true;
        if (this.isLoaded() && this.state != AdState.DISPLAYED) {
            this.state = AdState.DISPLAYED;
            if (this.publisherListener != null) {
                this.publisherListener.onRevMobAdDisplayed();
            }
            RevMobClient.getInstance().reportImpression(this.data.getImpressionUrl(), RevMobContext.toPayload(this.activity));
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    MarketAsyncManager marketAsyncManager = new MarketAsyncManager(RevMobLink.this.activity, RevMobLink.this.data, RevMobLink.this.publisherListener);
                    marketAsyncManager.execute(new Void[0]);
                }
            });
        } else if (this.state != AdState.CREATED && this.state != AdState.CLOSED) {
            RMLog.i("The ad is not completely loaded yet. As soon as it is loaded, it is going to be displayed automatically.");
        }
    }
}

