/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.popup;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.WindowManager;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdState;
import com.revmob.ads.popup.client.PopupClientListener;
import com.revmob.ads.popup.client.PopupData;
import com.revmob.android.RevMobContext;
import com.revmob.client.AdData;
import com.revmob.client.RevMobClient;
import com.revmob.internal.MarketAsyncManager;
import com.revmob.internal.RMLog;

public class RevMobPopup
implements Ad {
    private Activity activity;
    private PopupData data;
    public boolean autoshow = false;
    private AdState state;
    private RevMobAdsListener publisherListener;

    public RevMobPopup(Activity activity, RevMobAdsListener publisherListener) {
        this.activity = activity;
        this.publisherListener = publisherListener;
        this.state = AdState.CREATED;
    }

    public void load() {
        this.load(null);
    }

    public void load(String placementId) {
        if (this.state == AdState.CREATED || this.state == AdState.CLOSED) {
            RMLog.i(placementId != null ? "Loading Popup " + placementId : "Loading Popup");
            RevMobClient.getInstance().fetchPopup(placementId, RevMobContext.toPayload(this.activity), new PopupClientListener(this, this.publisherListener));
        }
    }

    public void updateWithData(AdData advertisement) {
        this.state = AdState.LOADED;
        this.data = (PopupData)advertisement;
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdReceived();
        }
        if (this.autoshow) {
            this.show();
        }
    }

    private boolean isLoaded() {
        return this.data != null;
    }

    public void show() {
        this.autoshow = true;
        if (this.isLoaded() && this.state != AdState.DISPLAYED) {
            this.state = AdState.DISPLAYED;
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    RevMobPopup.this.buildAndDisplayDialog();
                }
            });
        } else if (this.state != AdState.CREATED && this.state != AdState.CLOSED) {
            RMLog.i("The ad is not completely loaded yet. As soon as it is loaded, it is going to be displayed automatically.");
        }
    }

    public void hide() {
        this.autoshow = false;
    }

    private void buildAndDisplayDialog() {
        try {
            if (this.activity != null && !this.activity.isFinishing()) {
                AlertDialog.Builder dialog = new AlertDialog.Builder((Context)this.activity).setTitle((CharSequence)this.data.getMessage()).setPositiveButton((CharSequence)"Yes, sure!", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        RevMobPopup.this.activity.runOnUiThread(new Runnable(){

                            public void run() {
                                MarketAsyncManager marketAsyncManager = new MarketAsyncManager(RevMobPopup.this.activity, RevMobPopup.this.data, RevMobPopup.this.publisherListener);
                                marketAsyncManager.execute(new Void[0]);
                            }
                        });
                    }
                }).setNegativeButton((CharSequence)"No, thanks.", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        RevMobPopup.this.state = AdState.CLOSED;
                    }
                });
                dialog.show();
                if (this.publisherListener != null) {
                    this.publisherListener.onRevMobAdDisplayed();
                }
                RevMobClient.getInstance().reportImpression(this.data.getImpressionUrl(), RevMobContext.toPayload(this.activity));
            }
        }
        catch (WindowManager.BadTokenException e) {
            String message = "Invalid activity as argument: is there an activity running?";
            RMLog.w(message);
        }
    }
}

