/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.client;

import android.app.Activity;
import com.revmob.android.RevMobContext;
import com.revmob.client.InstallClientListener;
import com.revmob.client.RevMobClient;
import com.revmob.client.RevMobClientListener;
import com.revmob.internal.RMLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionClientListener
implements RevMobClientListener {
    private Activity activity;
    private boolean needToRegisterInstall;

    public SessionClientListener(Activity activity, boolean needToRegisterInstall) {
        this.activity = activity;
        this.needToRegisterInstall = needToRegisterInstall;
    }

    public void handleResponse(String response) throws JSONException {
        JSONObject json = new JSONObject(response);
        JSONArray links = json.getJSONArray("links");
        for (int i = 0; i < links.length(); ++i) {
            try {
                String key = links.getJSONObject(i).getString("rel");
                String url = links.getJSONObject(i).getString("href");
                RevMobClient.getInstance().addServerEndPoint(key, url);
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        if (this.needToRegisterInstall) {
            RevMobClient.getInstance().registerInstall(RevMobContext.toPayload(this.activity), new InstallClientListener(this.activity));
        }
    }

    public void handleError(String message) {
        RMLog.d(message);
    }
}

