/*
 * Decompiled with CFR 0.152.
 */
package com.chartboost.sdk.Libraries;

public enum CBOrientation {
    UNSPECIFIED,
    PORTRAIT,
    LANDSCAPE,
    PORTRAIT_REVERSE,
    LANDSCAPE_REVERSE;

    public static final CBOrientation PORTRAIT_LEFT;
    public static final CBOrientation PORTRAIT_RIGHT;
    public static final CBOrientation LANDSCAPE_LEFT;
    public static final CBOrientation LANDSCAPE_RIGHT;

    static {
        PORTRAIT_LEFT = PORTRAIT_REVERSE;
        PORTRAIT_RIGHT = PORTRAIT;
        LANDSCAPE_LEFT = LANDSCAPE;
        LANDSCAPE_RIGHT = LANDSCAPE_REVERSE;
    }

    public CBOrientation rotate90() {
        switch (this) {
            case LANDSCAPE: {
                return PORTRAIT_LEFT;
            }
            case PORTRAIT_REVERSE: {
                return LANDSCAPE_RIGHT;
            }
            case LANDSCAPE_REVERSE: {
                return PORTRAIT_RIGHT;
            }
            case PORTRAIT: {
                return LANDSCAPE_LEFT;
            }
        }
        return UNSPECIFIED;
    }

    public CBOrientation rotate180() {
        return this.rotate90().rotate90();
    }

    public CBOrientation rotate270() {
        return this.rotate90().rotate90().rotate90();
    }

    public boolean isPortrait() {
        return this == PORTRAIT || this == PORTRAIT_REVERSE;
    }

    public boolean isLandscape() {
        return this == LANDSCAPE || this == LANDSCAPE_REVERSE;
    }

    public static enum Difference {
        ANGLE_0,
        ANGLE_90,
        ANGLE_180,
        ANGLE_270;


        public int getAsInt() {
            switch (this) {
                case ANGLE_90: {
                    return 90;
                }
                case ANGLE_180: {
                    return 180;
                }
                case ANGLE_270: {
                    return 270;
                }
            }
            return 0;
        }

        public boolean isOdd() {
            return this == ANGLE_90 || this == ANGLE_270;
        }

        public boolean isReverse() {
            return this == ANGLE_180 || this == ANGLE_270;
        }
    }
}

