/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.banner.client;

import android.graphics.Bitmap;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.banner.client.BannerData;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdRevMobClientListener;
import com.revmob.internal.HTTPHelper;
import com.revmob.internal.RMLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerClientListener
extends AdRevMobClientListener {
    public BannerClientListener(Ad ad, RevMobAdsListener publisherListener) {
        super(ad, publisherListener);
    }

    public void handleResponse(String response) throws JSONException {
        JSONObject json = new JSONObject(response);
        json = json.getJSONArray("banners").getJSONObject(0);
        String appOrSite = BannerClientListener.getAppOrSite(json);
        boolean openInside = BannerClientListener.getOpenInside(json);
        JSONArray links = json.getJSONArray("links");
        String clickUrl = BannerClientListener.getClickUrl(links);
        String impressionUrl = BannerClientListener.getImpressionUrl(links);
        String htmlUrl = BannerClientListener.getLinkByRel(links, "html");
        String dspUrl = BannerClientListener.getLinkByRel(links, "dsp_url");
        String dspHtml = BannerClientListener.getLinkByRel(links, "dsp_html");
        Bitmap image = null;
        if (dspUrl != null || dspHtml != null) {
            RMLog.d("Banner DSP");
        } else if (htmlUrl == null) {
            String imageUrl = BannerClientListener.getLinkByRel(links, "image");
            RMLog.d("Banner imageUrl = " + imageUrl);
            HTTPHelper helper = new HTTPHelper();
            image = helper.downloadBitmap(imageUrl);
        }
        if (clickUrl != null && (htmlUrl != null || image != null) || dspUrl != null || dspHtml != null) {
            RMLog.i("Banner loaded");
            this.ad.updateWithData(new BannerData(impressionUrl, clickUrl, image, htmlUrl, dspUrl, dspHtml, appOrSite, openInside));
        }
    }
}

