/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.fullscreen.client.FullscreenData;
import com.revmob.ads.fullscreen.internal.FullscreenClickListener;
import com.revmob.ads.fullscreen.internal.FullscreenDSPClickListener;
import com.revmob.ads.fullscreen.internal.FullscreenStatic;
import com.revmob.ads.fullscreen.internal.FullscreenView;
import com.revmob.ads.fullscreen.internal.FullscreenWebViewClickListener;
import com.revmob.ads.fullscreen.internal.FullscreenWebview;
import com.revmob.ads.internal.StaticAssets;
import com.revmob.internal.AndroidHelper;
import com.revmob.internal.RMLog;
import com.revmob.internal.RevMobWebViewClient;

public class FullscreenActivity
extends Activity {
    private static final int BACKGROUND_COLOR = -587202560;
    private static Boolean fullscreenActivityAvailable;
    public FullscreenView fullscreenView;
    public RelativeLayout layout;
    public ProgressBar progressBar;
    public FullscreenData data;
    public RevMobAdsListener publisherListener;

    public static Boolean isFullscreenActivityAvailable(Activity activity) {
        if (fullscreenActivityAvailable == null) {
            fullscreenActivityAvailable = AndroidHelper.isIntentAvailable((Context)activity, FullscreenActivity.class);
        }
        return fullscreenActivityAvailable;
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        this.getWindow().setFlags(4, 4);
        Intent intent = this.getIntent();
        String adUrl = intent.getStringExtra("com.revmob.ads.fullscreen.adUrl");
        try {
            if (adUrl != null) {
                this.data = FullscreenData.getLoadedFullscreen(adUrl);
                this.publisherListener = this.data.getPublisherListener();
                this.createFullscreenView();
                ((View)this.fullscreenView).setAnimation(this.data.getShowAnimation());
                this.initFullscreen();
            } else {
                String marketURL = intent.getStringExtra("marketURL");
                this.createViewClickUrl(marketURL);
                this.initFullscreen();
                this.addProgressBar();
            }
        }
        catch (RuntimeException e) {
            RMLog.e("Unexpected error on create Fullscreen Ad.", e);
            if (this.publisherListener != null) {
                this.publisherListener.onRevMobAdNotReceived("Unexpected error on create Fullscreen Ad.");
            }
            this.finish();
        }
    }

    private void initFullscreen() {
        RelativeLayout.LayoutParams adViewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.layout = new RelativeLayout((Context)this);
        this.layout.setBackgroundColor(-587202560);
        this.layout.addView((View)this.fullscreenView, (ViewGroup.LayoutParams)adViewLayoutParams);
        this.setContentView((View)this.layout);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.fullscreenView.update();
    }

    public void addProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new ProgressBar((Context)this);
            this.progressBar.setIndeterminate(true);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            int margin = AndroidHelper.dipToPixels((Context)this, 15);
            params.setMargins(margin, margin, margin, margin);
            this.layout.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
        }
    }

    public void removeProgressBar() {
        if (this.progressBar != null) {
            this.layout.removeView((View)this.progressBar);
        }
    }

    private void createViewClickUrl(String clickUrl) {
        this.fullscreenView = new FullscreenWebview((Context)this, clickUrl, null, new RevMobWebViewClient(null, null){

            public void onPageFinished(WebView view, String url) {
                FullscreenActivity.this.removeProgressBar();
                FullscreenActivity.this.addCloseButton();
            }
        });
    }

    private void addCloseButton() {
        int padding;
        ImageView closeButton = new ImageView((Context)this);
        closeButton.setImageDrawable(StaticAssets.getCloseButton());
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FullscreenActivity.this.finish();
            }
        });
        int buttonSize = AndroidHelper.dipToPixels((Context)this, 40);
        RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(buttonSize, buttonSize);
        closeLayoutParams.rightMargin = padding = AndroidHelper.dipToPixels((Context)this, 20);
        closeLayoutParams.topMargin = padding;
        closeLayoutParams.addRule(11);
        closeLayoutParams.addRule(6);
        this.layout.addView((View)closeButton, (ViewGroup.LayoutParams)closeLayoutParams);
    }

    private void createFullscreenView() {
        if (this.data.isHtmlFullscreen()) {
            FullscreenWebViewClickListener clickListener = new FullscreenWebViewClickListener(this);
            RevMobWebViewClient client = new RevMobWebViewClient(this.publisherListener, clickListener);
            this.fullscreenView = new FullscreenWebview((Context)this, this.data.getHtmlAdUrl(), this.data.getHtmlCode(), client);
        } else if (this.data.isDspFullscreen()) {
            FullscreenDSPClickListener clickListener = new FullscreenDSPClickListener(this);
            RevMobWebViewClient client = new RevMobWebViewClient(this.publisherListener, clickListener);
            this.fullscreenView = new FullscreenWebview((Context)this, this.data.getDspUrl(), this.data.getDspHtml(), client);
        } else {
            FullscreenClickListener clickListener = new FullscreenClickListener(this);
            this.fullscreenView = new FullscreenStatic(this, this.data, clickListener);
        }
    }

    public void close() {
        Animation animation = this.data.getCloseAnimation();
        ((View)this.fullscreenView).setAnimation(animation);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                FullscreenActivity.this.layout.removeView((View)FullscreenActivity.this.fullscreenView);
                FullscreenActivity.this.layout.removeAllViews();
                FullscreenActivity.this.finish();
            }
        });
        ((View)this.fullscreenView).startAnimation(animation);
    }

    protected void onDestroy() {
        FullscreenData.cleanLoadedFullscreen(this.data);
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.publisherListener != null) {
                this.publisherListener.onRevMobAdDismiss();
            }
            this.finish();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void finish() {
        super.finish();
    }
}

