/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen.internal;

import com.revmob.ads.fullscreen.FullscreenActivity;
import com.revmob.internal.MarketAsyncManager;
import com.revmob.internal.RMLog;

public class FullscreenClickListener {
    protected boolean clicked = false;
    protected final FullscreenActivity fullscreenActivity;

    public FullscreenClickListener(FullscreenActivity fullscreenActivity) {
        this.fullscreenActivity = fullscreenActivity;
    }

    public boolean onClick() {
        if (!this.defaultClickHandler()) {
            this.openMarket();
        }
        return true;
    }

    public boolean onClose() {
        if (this.clicked) {
            return true;
        }
        this.clicked = true;
        if (this.fullscreenActivity.publisherListener != null) {
            this.fullscreenActivity.publisherListener.onRevMobAdDismiss();
        }
        this.fullscreenActivity.close();
        return true;
    }

    public boolean defaultClickHandler() {
        if (this.clicked) {
            return true;
        }
        this.clicked = true;
        this.fullscreenActivity.layout.setClickable(false);
        this.fullscreenActivity.addProgressBar();
        if (this.fullscreenActivity.publisherListener != null) {
            this.fullscreenActivity.publisherListener.onRevMobAdClicked();
        }
        return false;
    }

    public void openMarket() {
        this.fullscreenActivity.runOnUiThread(new Runnable(){

            public void run() {
                MarketAsyncManager marketAsyncManager = new MarketAsyncManager(FullscreenClickListener.this.fullscreenActivity, FullscreenClickListener.this.fullscreenActivity.data, FullscreenClickListener.this.fullscreenActivity.publisherListener, new MarketAsyncManager.MarketAsyncManagerListener(){

                    public void onPreExecute() {
                    }

                    public void onPostExecute() {
                        RMLog.d("Closing Fullscreen activity");
                        FullscreenClickListener.this.fullscreenActivity.finish();
                    }
                });
                marketAsyncManager.execute(new Void[0]);
            }
        });
    }
}

