/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen.internal;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.revmob.ads.fullscreen.client.FullscreenData;
import com.revmob.ads.fullscreen.internal.FullscreenClickListener;
import com.revmob.ads.fullscreen.internal.FullscreenView;
import com.revmob.ads.internal.StaticAssets;
import com.revmob.internal.AndroidHelper;

public class FullscreenStatic
extends RelativeLayout
implements FullscreenView {
    private ImageView fullscreenImageView;
    private FullscreenData data;

    public FullscreenStatic(Activity context, FullscreenData data, FullscreenClickListener clickListener) {
        super((Context)context);
        int padding;
        this.data = data;
        RelativeLayout.LayoutParams adViewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(this.createImageAdView(clickListener), (ViewGroup.LayoutParams)adViewLayoutParams);
        int buttonSize = AndroidHelper.dipToPixels((Context)context, 40);
        RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(buttonSize, buttonSize);
        closeLayoutParams.rightMargin = padding = AndroidHelper.dipToPixels((Context)context, 20);
        closeLayoutParams.topMargin = padding;
        closeLayoutParams.addRule(11);
        closeLayoutParams.addRule(6);
        this.addView(this.createCloseButton(clickListener), (ViewGroup.LayoutParams)closeLayoutParams);
    }

    public void update() {
        if (this.fullscreenImageView != null) {
            int orientation = this.getResources().getConfiguration().orientation;
            this.fullscreenImageView.setImageBitmap(this.data.getAdImage(orientation));
            if (this.data.isStaticMultiOrientationFullscreen()) {
                this.fullscreenImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            } else {
                this.fullscreenImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        }
    }

    private View createImageAdView(final FullscreenClickListener clickListener) {
        this.fullscreenImageView = new ImageView(this.getContext());
        this.update();
        this.fullscreenImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                clickListener.onClick();
            }
        });
        return this.fullscreenImageView;
    }

    private View createCloseButton(final FullscreenClickListener clickListener) {
        ImageView close = new ImageView(this.getContext());
        close.setImageDrawable(StaticAssets.getCloseButton());
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                clickListener.onClose();
            }
        });
        return close;
    }
}

