/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.android;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileCache {
    private static final String CACHE_DIR = "RevMob";
    private File cacheDir;

    public FileCache(Context context) {
        String storageState = Environment.getExternalStorageState();
        this.cacheDir = storageState.equals("mounted") ? new File(Environment.getExternalStorageDirectory(), CACHE_DIR) : context.getCacheDir();
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    public File getFile(String filename) {
        File f = new File(this.cacheDir, filename);
        return f;
    }

    public void write(File file, InputStream is) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            FileCache.copyStream(is, os);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

