/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.android;

import com.revmob.RevMobUserGender;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInformation {
    protected static UserInformation userInformation = null;
    private String email;
    private static RevMobUserGender userGender = RevMobUserGender.UNDEFINED;
    private int userAgeRangeMin = -1;
    private int userAgeRangeMax = -1;
    private Calendar userBirthday = null;
    private String userPage = null;
    private List<String> userInterests = null;
    private double minLatitude = -90.0;
    private double maxLatitude = 90.0;
    private double minLongitude = -180.0;
    private double maxLongitude = 180.0;
    private float userLocationAccuracy = -1.0f;
    private double userLocationLatitude = 0.0;
    private double userLocationLongitude = 0.0;

    public static UserInformation getInstance() {
        if (userInformation == null) {
            userInformation = new UserInformation();
        }
        return userInformation;
    }

    public JSONObject addUserData(JSONObject device) throws JSONException {
        int minimumAge = 13;
        if (this.userAgeRangeMin != -1) {
            device.put("age_range_min", this.userAgeRangeMin);
        }
        if (this.userAgeRangeMax != -1) {
            device.put("age_range_max", this.userAgeRangeMax);
        }
        if (this.userAgeRangeMin > 0 && this.userAgeRangeMax < 13) {
            return device;
        }
        if (this.userBirthday != null) {
            SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            device.put("birthday", (Object)date_format.format(this.userBirthday.getTime()));
            Calendar today = Calendar.getInstance(Locale.US);
            today.setTime(new Date());
            Calendar birthDatePlusMinimumAge = Calendar.getInstance(Locale.US);
            birthDatePlusMinimumAge.setTime(this.userBirthday.getTime());
            birthDatePlusMinimumAge.add(1, minimumAge);
            if (today.compareTo(birthDatePlusMinimumAge) == -1) {
                return device;
            }
        }
        if (this.email != null) {
            device.put("email", (Object)this.email);
        }
        if (userGender != RevMobUserGender.UNDEFINED) {
            device.put("gender", (Object)userGender.getValue());
        }
        if (this.userPage != null) {
            device.put("user_page", (Object)this.userPage);
        }
        if (this.userInterests != null && this.userInterests.size() > 0) {
            JSONArray list = new JSONArray();
            for (int i = 0; i < this.userInterests.size(); ++i) {
                list.put((Object)this.userInterests.get(i));
            }
            device.put("interests", (Object)list);
        }
        if (this.userLocationAccuracy != -1.0f) {
            device.put("accuracy", (double)this.userLocationAccuracy);
        }
        if (this.userLocationLatitude != 0.0 && this.userLocationLatitude <= this.maxLatitude && this.userLocationLatitude >= this.minLatitude) {
            device.put("latitude", this.userLocationLatitude);
        }
        if (this.userLocationLongitude != 0.0 && this.userLocationLongitude <= this.maxLongitude && this.userLocationLongitude >= this.minLongitude) {
            device.put("longitude", this.userLocationLongitude);
        }
        return device;
    }

    public RevMobUserGender getUserGender() {
        return userGender;
    }

    public void setUserGender(RevMobUserGender anUserGender) {
        userGender = anUserGender;
    }

    public int getUserAgeRangeMin() {
        return this.userAgeRangeMin;
    }

    public void setUserAgeRangeMin(int anUserAgeRangeMin) {
        this.userAgeRangeMin = anUserAgeRangeMin;
    }

    public int getUserAgeRangeMax() {
        return this.userAgeRangeMax;
    }

    public void setUserAgeRangeMax(int anUserAgeRangeMax) {
        this.userAgeRangeMax = anUserAgeRangeMax;
    }

    public Calendar getUserBirthday() {
        return this.userBirthday;
    }

    public void setUserBirthday(Calendar anUserBirthday) {
        this.userBirthday = anUserBirthday;
    }

    public String getUserPage() {
        return this.userPage;
    }

    public void setUserPage(String anUserPage) {
        this.userPage = anUserPage;
    }

    public List<String> getUserInterests() {
        return this.userInterests;
    }

    public void setUserInterests(List<String> anUserInterests) {
        this.userInterests = anUserInterests;
    }

    public void setUserLocationAccuracy(float anUserLocationAccuracy) {
        this.userLocationAccuracy = anUserLocationAccuracy;
    }

    public void setUserLocationLatitude(double anUserLocationLatitude) {
        this.userLocationLatitude = anUserLocationLatitude;
    }

    public void setUserLocationLongitude(double anUserLocationLongitude) {
        this.userLocationLongitude = anUserLocationLongitude;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

