/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.client;

import android.util.SparseArray;
import com.revmob.RevMobTestingMode;
import com.revmob.client.RevMobClientListener;
import com.revmob.internal.HTTPHelper;
import com.revmob.internal.RMLog;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.json.JSONException;

public class RevMobClient {
    private static final String PRODUCTION_SERVER_ADDRESS = "https://android.revmob.com";
    private static final String SESSIONS_PATH = "/api/v4/mobile_apps/%s/sessions.json";
    private static final String ADS_PATH = "/api/v4/mobile_apps/%s/%s/fetch_only.json";
    private static final String PLACEMENT_ADS_PATH = "/api/v4/mobile_apps/%s/placements/%s/%s/fetch_only.json";
    private static final String INSTALL_URL = "/api/v4/mobile_apps/%s/install.json";
    private static final String DEFAULT_DOWNLOAD_ERROR_MESSAGE = "RevMob did not answered as expected.";
    private static final String BAD_RESPONSE_MESSAGE = "Bad response from server.";
    private static final String PARSE_ERROR_MESSAGE = "Error on parse response from server.";
    private static final String PARSE_ERROR_MESSAGE2 = "Error on parse response from server. Unknown error.";
    private static final String NO_MEMORY_MESSAGE = "It was not possible to load the RevMob banner because your device run out of RAM memory.";
    public static final String SESSION_WARNING = "Call RevMobAds.start(activity, APP_ID) on application start/resume. It will help us to improve tracking and increase the eCPM.";
    private static final String ONE_APP_ID_PER_APP = "You can use just one App Id per application.";
    private static final String INVALID_APP_ID = "Invalid App ID.";
    private static final String INVALID_TIMEOUT = "Invalid timeout.";
    private static final SparseArray<String> LOG_MESSAGES = new SparseArray();
    private static final Map<String, String> serverEndPoints = new HashMap<String, String>();
    private static final int DEFAULT_TIMEOUT = 30;
    public static String SDK_NAME = "android";
    public static String SDK_VERSION = "6.4.2";
    private String appId;
    private boolean sessionStarted = false;
    private RevMobTestingMode testingMode = RevMobTestingMode.DISABLED;
    private static RevMobClient instance;

    private RevMobClient() {
    }

    public static RevMobClient getInstance() {
        return instance;
    }

    public boolean startSession(String appId, String payload, RevMobClientListener listener) {
        if (this.appId == null) {
            if (this.isAppIdValid(appId)) {
                this.sessionStarted = true;
                this.appId = appId;
                String url = PRODUCTION_SERVER_ADDRESS + String.format(SESSIONS_PATH, appId);
                this.serverRequest(url, payload, listener);
                HTTPHelper.globalTimeoutInSeconds = 30;
                return true;
            }
            RMLog.w(INVALID_APP_ID);
        } else {
            RMLog.w(ONE_APP_ID_PER_APP);
        }
        return false;
    }

    void addServerEndPoint(String key, String url) {
        if (key != null && url != null) {
            serverEndPoints.put(key, url);
        }
    }

    public void registerInstall(String payload, RevMobClientListener listener) {
        String key = "install";
        String url = serverEndPoints.containsKey(key) ? serverEndPoints.get(key) : PRODUCTION_SERVER_ADDRESS + String.format(INSTALL_URL, this.appId);
        this.serverRequestWithSessionVerification(url, payload, listener);
    }

    public void fetchFullscreen(String placementId, String payload, RevMobClientListener listener) {
        String url = this.createFetchUrl("fullscreen", "fullscreens", this.appId, placementId);
        this.fetch(url, payload, listener);
    }

    public void fetchBanner(String placementId, String payload, RevMobClientListener listener) {
        String url = this.createFetchUrl("banner", "banners", this.appId, placementId);
        this.fetch(url, payload, listener);
    }

    public void fetchAdLink(String placementId, String payload, RevMobClientListener listener) {
        String url = this.createFetchUrl("link", "anchors", this.appId, placementId);
        this.fetch(url, payload, listener);
    }

    public void fetchPopup(String placementId, String payload, RevMobClientListener listener) {
        String url = this.createFetchUrl("pop_up", "pop_ups", this.appId, placementId);
        this.fetch(url, payload, listener);
    }

    public void fetchNotification(String placementId, String payload, RevMobClientListener listener) {
        String url = this.createFetchUrl("local_notification", "local_notifications", this.appId, placementId);
        this.fetch(url, payload, listener);
    }

    void fetch(String url, String payload, RevMobClientListener listener) {
        if (this.testingMode != RevMobTestingMode.DISABLED) {
            RMLog.i("Fetching ad using testing mode: " + this.testingMode.getValue());
        }
        this.serverRequestWithSessionVerification(url, payload, listener);
    }

    public void reportImpression(String url, String payload) {
        if (url != null) {
            if (this.testingMode != RevMobTestingMode.DISABLED) {
                RMLog.i("Reporting impression using testing mode: " + this.testingMode.getValue());
            }
            this.serverRequestWithSessionVerification(url, payload, null);
        }
    }

    void serverRequestWithSessionVerification(String url, String payload, RevMobClientListener listener) {
        if (!this.sessionStarted) {
            RMLog.w(SESSION_WARNING);
            return;
        }
        this.serverRequest(url, payload, listener);
    }

    boolean isPlacementIdValid(String placementId) {
        return placementId != null && placementId.length() == 24;
    }

    String createFetchUrl(String adUnitKey, String adUnitOldKey, String appId, String placementId) {
        if (this.isPlacementIdValid(placementId)) {
            String key = "fetch_" + adUnitKey + "_with_placement";
            if (serverEndPoints.containsKey(key)) {
                return serverEndPoints.get(key).replaceFirst("PLACEMENT_ID", placementId);
            }
            return PRODUCTION_SERVER_ADDRESS + String.format(PLACEMENT_ADS_PATH, appId, placementId, adUnitOldKey);
        }
        String key = "fetch_" + adUnitKey;
        if (serverEndPoints.containsKey(key)) {
            return serverEndPoints.get(key);
        }
        return PRODUCTION_SERVER_ADDRESS + String.format(ADS_PATH, appId, adUnitOldKey);
    }

    void serverRequest(final String url, final String payload, final RevMobClientListener listener) {
        Thread fetchThread = new Thread(){

            public void run() {
                HTTPHelper httpHelper = new HTTPHelper();
                HttpResponse response = httpHelper.post(url, payload);
                RevMobClient.this.processResponse(response, listener);
            }
        };
        fetchThread.start();
    }

    void processResponse(HttpResponse response, RevMobClientListener listener) {
        if (response == null) {
            this.handleDownloadError(0, listener);
            return;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 202) {
            this.handleDownloadError(statusCode, listener);
        } else {
            String encodedResponseBody = HTTPHelper.encodedResponseBody(response.getEntity());
            if (encodedResponseBody == null) {
                RMLog.w(BAD_RESPONSE_MESSAGE);
                if (listener != null) {
                    listener.handleError(BAD_RESPONSE_MESSAGE);
                }
                return;
            }
            RMLog.d("Server request successful (" + statusCode + ")");
            this.handleSuccess(encodedResponseBody, listener);
        }
    }

    void handleSuccess(String encodedResponseBody, RevMobClientListener listener) {
        block7: {
            try {
                if (listener != null) {
                    listener.handleResponse(encodedResponseBody);
                }
            }
            catch (OutOfMemoryError e) {
                RMLog.w(NO_MEMORY_MESSAGE);
                if (listener != null) {
                    listener.handleError(NO_MEMORY_MESSAGE);
                }
            }
            catch (JSONException e) {
                RMLog.w(PARSE_ERROR_MESSAGE);
                if (listener != null) {
                    listener.handleError(PARSE_ERROR_MESSAGE);
                }
            }
            catch (NullPointerException e) {
                RMLog.w(PARSE_ERROR_MESSAGE2);
                if (listener == null) break block7;
                listener.handleError(PARSE_ERROR_MESSAGE2);
            }
        }
    }

    void handleDownloadError(int statusCode, RevMobClientListener listener) {
        String message = (String)LOG_MESSAGES.get(statusCode, (Object)DEFAULT_DOWNLOAD_ERROR_MESSAGE);
        message = message + " (" + statusCode + ")";
        RMLog.w(message);
        if (listener != null) {
            listener.handleError(message);
        }
    }

    boolean isAppIdValid(String appId) {
        return appId != null && appId.length() == 24;
    }

    public RevMobTestingMode getTestingMode() {
        return this.testingMode;
    }

    public void setTestingMode(RevMobTestingMode testingMode) {
        this.testingMode = testingMode;
        if (testingMode != RevMobTestingMode.DISABLED) {
            RMLog.i("Testing mode enabled: " + testingMode.getValue());
        } else {
            RMLog.i("Testing mode disabled");
        }
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        if (timeoutInSeconds > 1 && timeoutInSeconds < 300) {
            HTTPHelper.globalTimeoutInSeconds = timeoutInSeconds;
            RMLog.i("Timeout changed to " + timeoutInSeconds + "s");
        } else {
            RMLog.w(INVALID_TIMEOUT);
        }
    }

    public static void setSDKName(String sdkName) {
        if (sdkName != null) {
            SDK_NAME = sdkName;
        }
    }

    public static void setSDKVersion(String sdkVersion) {
        if (sdkVersion != null) {
            SDK_VERSION = sdkVersion;
        }
    }

    public String getAppId() {
        return this.appId;
    }

    static {
        LOG_MESSAGES.put(200, (Object)"OK.");
        LOG_MESSAGES.put(202, (Object)"OK.");
        LOG_MESSAGES.put(204, (Object)"Ad retrieval failed: No ads for this device/country right now or your App ID is paused.");
        LOG_MESSAGES.put(404, (Object)"No ad retrieved: did you set a valid App ID? Get one at http://revmob.com.");
        LOG_MESSAGES.put(409, (Object)"No ad retrieved: did you set a valid Placement ID? Get one at http://revmob.com.");
        LOG_MESSAGES.put(422, (Object)"Request requirements did not met. Did you set required permissions?");
        LOG_MESSAGES.put(423, (Object)"Is your ad unit paused? Please, check it in the RevMob Console.");
        LOG_MESSAGES.put(500, (Object)"Unexpected server error.");
        LOG_MESSAGES.put(503, (Object)"Unexpected server error.");
        instance = new RevMobClient();
    }
}

