/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import com.revmob.android.RevMobScreen;
import com.revmob.internal.RMLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HTTPHelper {
    private AbstractHttpClient httpclient;
    public static int globalTimeoutInSeconds = 30;

    public HTTPHelper() {
        this((AbstractHttpClient)new DefaultHttpClient());
    }

    public HTTPHelper(AbstractHttpClient client) {
        this.httpclient = client;
        this.setTimeout(globalTimeoutInSeconds);
        SchemeRegistry schemeRegistry = this.httpclient.getConnectionManager().getSchemeRegistry();
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
    }

    public void setTimeout(int timeoutInSeconds) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(timeoutInSeconds * 1000));
        this.httpclient.setParams((HttpParams)params);
    }

    public HttpResponse get(String url) {
        HttpGet httpGet = new HttpGet(url);
        return this.sendRequestDealingWithSSLErrors((HttpRequestBase)httpGet);
    }

    public HttpResponse post(String url, String entity) {
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(entity, "UTF-8"));
            httpPost.setHeader("content-type", "application/json");
            return this.sendRequestDealingWithSSLErrors((HttpRequestBase)httpPost);
        }
        catch (UnsupportedEncodingException e) {
            RMLog.w("Encoding error.", e);
        }
        catch (RuntimeException e) {
            RMLog.e("Unknown error", e);
        }
        return null;
    }

    public InputStream getAndReturnTheStream(String url) {
        try {
            HttpResponse response = this.get(url);
            if (response != null && response.getEntity() != null) {
                return response.getEntity().getContent();
            }
        }
        catch (IllegalStateException e) {
            RMLog.e("Read error.");
        }
        catch (IOException e) {
            RMLog.w("Read error.");
        }
        return null;
    }

    public static String encodedResponseBody(HttpEntity entity) {
        if (entity == null) {
            return null;
        }
        String response = "";
        try {
            int cnt;
            int length = 1024;
            StringBuffer sb = new StringBuffer(length);
            InputStreamReader isr = new InputStreamReader(entity.getContent(), "UTF-8");
            char[] buff = new char[length];
            while ((cnt = isr.read(buff, 0, length - 1)) > 0) {
                sb.append(buff, 0, cnt);
            }
            response = sb.toString();
            isr.close();
        }
        catch (IOException ioe) {
            RMLog.w("Read error.");
        }
        return response;
    }

    private HttpResponse sendRequest(HttpRequestBase requestInfo) throws SSLException {
        try {
            HttpResponse response = this.httpclient.execute((HttpUriRequest)requestInfo);
            return response;
        }
        catch (UnknownHostException e) {
            RMLog.w("Error on requesting path " + requestInfo.getRequestLine() + ". Is the device connected to the internet?", e);
        }
        catch (HttpHostConnectException e) {
            throw new SSLException(e);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new SSLException(e);
        }
        catch (SocketException e) {
            RMLog.w("Server took too long to respond.");
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            RMLog.w("Error on requesting path " + requestInfo.getRequestLine() + ". Did the device lost its connection?", e);
        }
        return null;
    }

    private HttpResponse sendRequestDealingWithSSLErrors(HttpRequestBase requestInfo) {
        try {
            return this.sendRequest(requestInfo);
        }
        catch (SSLException e) {
            try {
                String url = requestInfo.getURI().toString();
                if (url.startsWith("https://")) {
                    URI httpURL = new URI(requestInfo.getURI().toString().replace("https://", "http://"));
                    requestInfo.setURI(httpURL);
                    return this.sendRequest(requestInfo);
                }
            }
            catch (SSLException e1) {
                RMLog.i("Problem with SSL. What is the version of your Android?");
            }
            catch (URISyntaxException e1) {
                RMLog.e("Invalid url: " + requestInfo.getURI().toString());
            }
            return null;
        }
    }

    public Drawable downloadImage(String url) {
        InputStream stream = this.getAndReturnTheStream(url);
        return Drawable.createFromStream((InputStream)stream, (String)"src");
    }

    public int[] getImageSize(String url) {
        InputStream stream = this.getAndReturnTheStream(url);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        try {
            stream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return new int[]{imageWidth, imageHeight};
    }

    public static int calculateInSampleSize(int[] imageSize, int reqWidth, int reqHeight) {
        int width = imageSize[0];
        int height = imageSize[1];
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize < 4 ? inSampleSize : 3;
    }

    public Bitmap downloadBitmap(String url) {
        int[] imageSize = this.getImageSize(url);
        int inSampleSize = HTTPHelper.calculateInSampleSize(imageSize, RevMobScreen.getScreenWidth(), RevMobScreen.getScreenHeight());
        InputStream stream = this.getAndReturnTheStream(url);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = inSampleSize;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        return bitmap;
    }

    public String downloadHtml(String url) {
        HttpResponse response = this.get(url);
        if (response != null && response.getEntity() != null) {
            return HTTPHelper.encodedResponseBody(response.getEntity());
        }
        return null;
    }
}

