/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.internal;

import com.revmob.internal.HTTPHelper;
import com.revmob.internal.LocationUrlNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.protocol.HttpContext;

public class MarketRedirector {
    private static int TIMEOUT_IN_SECONDS = 30;
    private static Pattern GOOGLE_PLAY_URL_PATTERN = Pattern.compile("details\\?id=[a-zA-Z0-9\\.]+");
    private static Pattern AMAZON_URL_PATTERN = Pattern.compile("android\\?p=[a-zA-Z0-9\\.]+");
    private String url;
    private String entity;
    private AbstractHttpClient httpclient;
    private RedirectHandler redirectHandler;

    public static boolean isGooglePlayUri(String uri) {
        return uri.startsWith("market://");
    }

    public static boolean isAmazonAppStoreUri(String uri) {
        return uri.startsWith("amzn://");
    }

    static String rewriteMarketUrl(String url) {
        Matcher googleplayMatcher = GOOGLE_PLAY_URL_PATTERN.matcher(url);
        Matcher amazonMatcher = AMAZON_URL_PATTERN.matcher(url);
        if (googleplayMatcher.find()) {
            String detailId = googleplayMatcher.group();
            return "market://" + detailId;
        }
        if (amazonMatcher.find()) {
            String detailId = amazonMatcher.group();
            return "amzn://apps/" + detailId;
        }
        return url;
    }

    public MarketRedirector(String url) {
        this(url, "", (AbstractHttpClient)new DefaultHttpClient(), (RedirectHandler)new MarketRedirectHandler());
    }

    public MarketRedirector(String url, String entity) {
        this(url, entity, (AbstractHttpClient)new DefaultHttpClient(), (RedirectHandler)new MarketRedirectHandler());
    }

    MarketRedirector(String url, String entity, AbstractHttpClient client, RedirectHandler handler) {
        this.url = url;
        this.entity = entity;
        this.httpclient = client;
        this.redirectHandler = handler;
        this.httpclient.setRedirectHandler(this.redirectHandler);
    }

    public String getMarketUrl() throws LocationUrlNotFoundException {
        if (MarketRedirector.isGooglePlayUri(this.url) || MarketRedirector.isAmazonAppStoreUri(this.url)) {
            return this.url;
        }
        this.post();
        URI locationUrl = ((MarketRedirectHandler)this.redirectHandler).getLastRedirectedUrl();
        if (locationUrl == null) {
            throw new LocationUrlNotFoundException();
        }
        return MarketRedirector.rewriteMarketUrl(locationUrl.toString());
    }

    HttpResponse post() {
        HTTPHelper httpHelper = new HTTPHelper(this.httpclient);
        httpHelper.setTimeout(TIMEOUT_IN_SECONDS);
        return httpHelper.post(this.url, this.entity);
    }

    static class MarketRedirectHandler
    extends DefaultRedirectHandler {
        private URI lastRedirectedUri;

        MarketRedirectHandler() {
        }

        public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
            String locationUri;
            Header locationHeader = response.getLastHeader("Location");
            if (locationHeader != null && (MarketRedirector.isGooglePlayUri(locationUri = locationHeader.getValue()) || MarketRedirector.isAmazonAppStoreUri(locationUri))) {
                try {
                    this.lastRedirectedUri = new URI(locationUri);
                    return false;
                }
                catch (URISyntaxException e) {
                    return super.isRedirectRequested(response, context);
                }
            }
            return super.isRedirectRequested(response, context);
        }

        public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
            this.lastRedirectedUri = super.getLocationURI(response, context);
            return this.lastRedirectedUri;
        }

        public URI getLastRedirectedUrl() {
            return this.lastRedirectedUri;
        }
    }
}

