/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.internal;

import android.content.Context;
import android.webkit.WebView;
import com.revmob.internal.RevMobWebViewClient;

public class RevMobWebView
extends WebView {
    public RevMobWebView(Context context, String url, String html, RevMobWebViewClient client) {
        super(context);
        this.setScrollContainer(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.getSettings().setAppCacheEnabled(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setLoadsImagesAutomatically(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setSaveFormData(false);
        this.getSettings().setSavePassword(false);
        if (client != null) {
            this.setWebViewClient(client);
        }
        if (html != null && !html.equals("")) {
            this.loadData(html, "text/html; charset=UTF-8", "utf-8");
        } else {
            this.loadUrl(url);
        }
    }

    public void loadData(String data, String mimeType, String encoding) {
        super.loadData(this.solveAndroidBug(data), mimeType, encoding);
    }

    private String solveAndroidBug(String data) {
        StringBuilder sb = new StringBuilder(data.length() + 100);
        char[] dataChars = data.toCharArray();
        block5: for (int i = 0; i < dataChars.length; ++i) {
            char ch = data.charAt(i);
            switch (ch) {
                case '%': {
                    sb.append("%25");
                    continue block5;
                }
                case '\'': {
                    sb.append("%27");
                    continue block5;
                }
                case '#': {
                    sb.append("%23");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

