/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.banner;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.banner.client.BannerClientListener;
import com.revmob.ads.banner.client.BannerData;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdState;
import com.revmob.android.RevMobContext;
import com.revmob.client.AdData;
import com.revmob.client.RevMobClient;
import com.revmob.internal.MarketAsyncManager;
import com.revmob.internal.RMLog;
import com.revmob.internal.RevMobWebView;
import com.revmob.internal.RevMobWebViewClient;

public class RevMobBanner
extends RelativeLayout
implements Ad {
    private static final int DEFAULT_WIDTH_IN_DIP = 320;
    private static final int DEFAULT_HEIGHT_IN_DIP = 50;
    private Activity activity;
    private BannerData data;
    private RevMobAdsListener publisherListener;
    private View adView;
    private AdState state;
    private int width = 320;
    private int height = 50;
    final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            RevMobBanner.this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    MarketAsyncManager marketAsyncManager = new MarketAsyncManager(RevMobBanner.this.activity, RevMobBanner.this.data, RevMobBanner.this.publisherListener);
                    marketAsyncManager.execute(new Void[0]);
                }
            });
        }
    };

    public RevMobBanner(Activity activity, RevMobAdsListener publisherListener) {
        super((Context)activity);
        this.activity = activity;
        this.publisherListener = publisherListener;
        this.state = AdState.CREATED;
    }

    public void load() {
        this.load(null);
    }

    public void load(String placementId) {
        if (this.state == AdState.CREATED || this.state == AdState.CLOSED) {
            RMLog.i(placementId != null ? "Loading Banner " + placementId : "Loading Banner");
            RevMobClient.getInstance().fetchBanner(placementId, RevMobContext.toPayload(this.activity), new BannerClientListener(this, this.publisherListener));
        }
    }

    public void updateWithData(AdData advertisement) {
        this.state = AdState.LOADED;
        this.data = (BannerData)advertisement;
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdReceived();
        }
        this.setOnClickListener(this.onClickListener);
        ((Activity)this.getContext()).runOnUiThread(new Runnable(){

            public void run() {
                if (RevMobBanner.this.data.isHtmlBanner()) {
                    RevMobBanner.this.addHtmlAdView();
                } else if (RevMobBanner.this.data.isDspBanner()) {
                    RevMobBanner.this.addDSPAdView();
                } else {
                    RevMobBanner.this.addImageView();
                }
                RevMobBanner.this.reportShowOrHidden();
            }
        });
    }

    public void reportShowOrHidden() {
        if (this.isShown()) {
            if (this.isLoaded() && this.state != AdState.DISPLAYED) {
                this.state = AdState.DISPLAYED;
                if (this.publisherListener != null) {
                    this.publisherListener.onRevMobAdDisplayed();
                }
                RevMobClient.getInstance().reportImpression(this.data.getImpressionUrl(), RevMobContext.toPayload(this.activity));
            }
        } else {
            this.state = AdState.HIDDEN;
        }
    }

    private void calculateDimensions() {
        View parentView = (View)this.getParent();
        int displayWidth = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getWidth();
        this.width = parentView != null && parentView.getWidth() != 0 ? parentView.getWidth() : displayWidth;
        int idealHeight = this.width * 50 / 320;
        this.height = parentView != null && parentView.getHeight() != 0 ? Math.min(parentView.getHeight(), idealHeight) : idealHeight;
    }

    private void addImageView() {
        this.adView = new ImageView(this.getContext());
        ((ImageView)this.adView).setImageBitmap(this.data.getDrawable());
        if (this.getParent() != null) {
            ((View)this.getParent()).setVisibility(0);
        }
        this.calculateDimensions();
        this.adView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.width, this.height));
        ((ImageView)this.adView).setScaleType(ImageView.ScaleType.FIT_XY);
        this.adView.setOnClickListener(this.onClickListener);
        this.addView(this.adView);
    }

    private void addHtmlAdView() {
        RevMobWebViewClient client = new RevMobWebViewClient(this.publisherListener, new RevMobWebViewClient.RevMobWebViewClickListener(){

            public boolean handleClick(WebView view, String url) {
                if (url.endsWith("#click")) {
                    RevMobBanner.this.onClickListener.onClick(RevMobBanner.this.adView);
                }
                return true;
            }

            public void handlePageFinished(WebView view, String url) {
            }
        });
        this.adView = new RevMobWebView(this.getContext(), this.data.getHtmlAdUrl(), null, client);
        this.adView.setBackgroundColor(0);
        this.calculateDimensions();
        this.adView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.width, this.height));
        this.adView.bringToFront();
        this.addView(this.adView);
    }

    private void addDSPAdView() {
        RevMobWebViewClient client = new RevMobWebViewClient(this.publisherListener, new RevMobWebViewClient.RevMobWebViewClickListener(){

            public boolean handleClick(WebView view, String url) {
                RevMobBanner.this.onClickListener.onClick(RevMobBanner.this.adView);
                return true;
            }

            public void handlePageFinished(WebView view, String url) {
            }
        });
        this.adView = new RevMobWebView(this.getContext(), this.data.getDspUrl(), this.data.getDspHtml(), client);
        this.adView.setBackgroundColor(0);
        this.calculateDimensions();
        this.adView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.width, this.height));
        this.adView.bringToFront();
        this.addView(this.adView);
    }

    private boolean isLoaded() {
        return this.data != null;
    }
}

