/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.fullscreen.FullscreenActivity;
import com.revmob.ads.fullscreen.client.FullscreenClientListener;
import com.revmob.ads.fullscreen.client.FullscreenData;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdState;
import com.revmob.android.RevMobContext;
import com.revmob.client.AdData;
import com.revmob.client.RevMobClient;
import com.revmob.internal.RMLog;

public class RevMobFullscreen
implements Ad {
    private Activity activity;
    private FullscreenData data;
    public boolean autoshow = false;
    private AdState state;
    private RevMobAdsListener publisherListener;

    public RevMobFullscreen(Activity activity, RevMobAdsListener publisherListener) {
        this.activity = activity;
        this.publisherListener = publisherListener;
        this.state = AdState.CREATED;
    }

    public void load() {
        this.load(null);
    }

    public void load(String placementId) {
        if (this.state == AdState.CREATED || this.state == AdState.CLOSED) {
            this.state = AdState.LOADING;
            RMLog.i(placementId != null ? "Loading Fullscreen " + placementId : "Loading Fullscreen");
            RevMobClient.getInstance().fetchFullscreen(placementId, RevMobContext.toPayload(this.activity), new FullscreenClientListener(this, this.publisherListener));
        }
    }

    public void updateWithData(AdData advertisement) {
        this.state = AdState.LOADED;
        this.data = (FullscreenData)advertisement;
        FullscreenData.addLoadedFullscreen(this.data);
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdReceived();
        }
        if (this.autoshow) {
            this.show();
        }
    }

    private boolean isLoaded() {
        return this.data != null;
    }

    public void show() {
        this.autoshow = true;
        if (this.isLoaded() && this.state != AdState.DISPLAYED) {
            if (FullscreenActivity.isFullscreenActivityAvailable(this.activity).booleanValue()) {
                this.state = AdState.DISPLAYED;
                Intent i = new Intent((Context)this.activity, FullscreenActivity.class);
                i.putExtra("com.revmob.ads.fullscreen.adUrl", this.data.getClickUrl());
                this.activity.startActivityForResult(i, 0);
                if (this.publisherListener != null) {
                    this.publisherListener.onRevMobAdDisplayed();
                }
                RevMobClient.getInstance().reportImpression(this.data.getImpressionUrl(), RevMobContext.toPayload(this.activity));
            } else {
                this.state = AdState.CLOSED;
                RMLog.e("You must declare the RevMob FullscreenActivity in the AndroidManifest.xml file");
            }
        } else if (this.state != AdState.CREATED && this.state != AdState.CLOSED) {
            RMLog.i("The ad is not completely loaded yet. As soon as it is loaded, it is going to be displayed automatically.");
        }
    }

    public void hide() {
        this.autoshow = false;
        this.activity.finishActivity(0);
    }
}

