/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.fullscreen.client;

import android.graphics.Bitmap;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.fullscreen.client.FullscreenData;
import com.revmob.ads.internal.Ad;
import com.revmob.ads.internal.AdRevMobClientListener;
import com.revmob.ads.internal.CloseAnimationConfiguration;
import com.revmob.ads.internal.ShowAnimationConfiguration;
import com.revmob.internal.HTTPHelper;
import com.revmob.internal.RMLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FullscreenClientListener
extends AdRevMobClientListener {
    public FullscreenClientListener(Ad ad, RevMobAdsListener publisherListener) {
        super(ad, publisherListener);
    }

    public void handleResponse(String response) throws JSONException {
        this.ad.updateWithData(FullscreenClientListener.createData(response, this.publisherListener));
    }

    public static FullscreenData createData(String response, RevMobAdsListener publisherListener) throws JSONException {
        JSONObject json = new JSONObject(response);
        json = json.getJSONObject("fullscreen");
        String appOrSite = FullscreenClientListener.getAppOrSite(json);
        boolean openInside = FullscreenClientListener.getOpenInside(json);
        JSONArray links = json.getJSONArray("links");
        String clickUrl = FullscreenClientListener.getClickUrl(links);
        String impressionUrl = FullscreenClientListener.getImpressionUrl(links);
        String htmlUrl = FullscreenClientListener.getLinkByRel(links, "html");
        String dspUrl = FullscreenClientListener.getLinkByRel(links, "dsp_url");
        String dspHtml = FullscreenClientListener.getLinkByRel(links, "dsp_html");
        String imagePortraitUrl = FullscreenClientListener.getLinkByRel(links, "image_portrait");
        String imageLandscapeUrl = FullscreenClientListener.getLinkByRel(links, "image_landscape");
        String imageSquareUrl = FullscreenClientListener.getLinkByRel(links, "image");
        ShowAnimationConfiguration showAnimation = new ShowAnimationConfiguration();
        CloseAnimationConfiguration closeAnimation = new CloseAnimationConfiguration();
        try {
            int i;
            JSONObject animation = json.getJSONObject("animation");
            long duration = animation.getLong("duration");
            showAnimation.setTime(duration);
            closeAnimation.setTime(duration);
            JSONArray jsonArray = animation.getJSONArray("show");
            for (i = 0; i < jsonArray.length(); ++i) {
                showAnimation.addAnimation(jsonArray.getString(i));
            }
            jsonArray = animation.getJSONArray("close");
            for (i = 0; i < jsonArray.length(); ++i) {
                closeAnimation.addAnimation(jsonArray.getString(i));
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        Bitmap imageSquare = null;
        Bitmap imagePortrait = null;
        Bitmap imageLandscape = null;
        HTTPHelper helper = new HTTPHelper();
        String htmlCode = null;
        if (dspUrl != null || dspHtml != null) {
            RMLog.d("Fullscreen DSP");
        } else if (htmlUrl == null) {
            if (imagePortraitUrl != null && imageLandscapeUrl != null) {
                RMLog.d("Fullscreen static for orientations");
                imagePortrait = helper.downloadBitmap(imagePortraitUrl);
                imageLandscape = helper.downloadBitmap(imageLandscapeUrl);
            } else {
                RMLog.d("Fullscreen static");
                imageSquare = helper.downloadBitmap(imageSquareUrl);
            }
        } else {
            RMLog.d("Fullscreen Web");
            htmlCode = helper.downloadHtml(htmlUrl);
        }
        RMLog.i("Fullscreen loaded");
        return new FullscreenData(impressionUrl, clickUrl, publisherListener, htmlUrl, htmlCode, dspUrl, dspHtml, imageSquare, imageLandscape, imagePortrait, showAnimation, closeAnimation, appOrSite, openInside);
    }
}

