/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.ads.internal;

import com.revmob.RevMobAdsListener;
import com.revmob.ads.internal.Ad;
import com.revmob.client.RevMobClientListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AdRevMobClientListener
implements RevMobClientListener {
    protected RevMobAdsListener publisherListener;
    protected Ad ad;

    public AdRevMobClientListener(Ad ad, RevMobAdsListener publisherListener) {
        this.ad = ad;
        this.publisherListener = publisherListener;
    }

    public void handleResponse(String response) throws JSONException {
    }

    public void handleError(String message) {
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdNotReceived("Ad not received: " + message);
        }
    }

    public static String optionalGetString(JSONObject json, String key, String defaultValue) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public static String getLinkByRel(JSONArray links, String rel) throws JSONException {
        for (int i = 0; i < links.length(); ++i) {
            String relValue = links.getJSONObject(i).getString("rel");
            if (!relValue.equals(rel)) continue;
            return links.getJSONObject(i).getString("href");
        }
        return null;
    }

    public static String getClickUrl(JSONArray links) throws JSONException {
        return AdRevMobClientListener.getLinkByRel(links, "clicks");
    }

    public static String getImpressionUrl(JSONArray links) throws JSONException {
        return AdRevMobClientListener.getLinkByRel(links, "impressions");
    }

    public static String getAppOrSite(JSONObject json) throws JSONException {
        return AdRevMobClientListener.optionalGetString(json, "app_or_site", "app");
    }

    public static boolean getOpenInside(JSONObject json) throws JSONException {
        return Boolean.parseBoolean(AdRevMobClientListener.optionalGetString(json, "open_inside", "false"));
    }
}

