/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.android;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.revmob.RevMobTestingMode;
import com.revmob.android.StoredData;
import com.revmob.android.UserInformation;
import com.revmob.client.RevMobClient;
import com.revmob.internal.AndroidHelper;
import com.revmob.internal.RMLog;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class RevMobContext {
    private Context activity;
    private DisplayMetrics metrics = new DisplayMetrics();

    public RevMobContext(Context context) {
        this.activity = context;
        ((Activity)this.activity).getWindowManager().getDefaultDisplay().getMetrics(this.metrics);
    }

    public static String toPayload(Activity activity) {
        RevMobContext device = new RevMobContext((Context)activity);
        return device.toPayload();
    }

    public String toPayload() {
        try {
            JSONObject json = new JSONObject();
            json.put("device", (Object)this.getDeviceJSON());
            json.put("sdk", (Object)this.getSDKJSON());
            json.put("social", (Object)this.getSocialJSON());
            json.put("app", (Object)this.getAppJSON());
            if (RevMobClient.getInstance().getTestingMode() != RevMobTestingMode.DISABLED) {
                JSONObject testing = new JSONObject();
                testing.put("response", (Object)RevMobClient.getInstance().getTestingMode().getValue());
                json.put("testing", (Object)testing);
            }
            return json.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private JSONObject getSocialJSON() throws JSONException {
        JSONObject json = new JSONObject();
        UserInformation.getInstance().addUserData(json);
        return json;
    }

    public JSONObject getSDKJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", (Object)RevMobClient.SDK_NAME);
        json.put("version", (Object)RevMobClient.SDK_VERSION);
        json.put("testing_mode", (Object)RevMobClient.getInstance().getTestingMode().getValue());
        return json;
    }

    public JSONObject getDeviceJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("identities", (Object)this.getIdentitiesJSON());
        this.putIfNotEmpty(json, "model", this.getModel());
        this.putIfNotEmpty(json, "api", "" + this.getApiVersion());
        this.putIfNotEmpty(json, "manufacturer", this.getManufacturer());
        this.putIfNotEmpty(json, "os_version", this.getOsVersion());
        this.putIfNotEmpty(json, "connection_speed", this.getNetworkConnectionType());
        this.putIfNotEmpty(json, "locale", RevMobContext.getLocale());
        this.putIfNotEmpty(json, "ua", RevMobContext.getUserAgent());
        json.put("screen", (Object)this.getDeviceScreenJSON());
        return json;
    }

    private JSONObject getIdentitiesJSON() throws JSONException {
        JSONObject json = new JSONObject();
        this.putIfNotEmpty(json, "mac_address", this.getMACAddress());
        this.putIfNotEmpty(json, "mobile_id", this.getMobileID());
        this.putIfNotEmpty(json, "android_id", this.getAndroidID());
        this.putIfNotEmpty(json, "serial", this.getSerial());
        return json;
    }

    public JSONObject getDeviceScreenJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("width", this.metrics.widthPixels);
        json.put("height", this.metrics.heightPixels);
        json.put("scale", (double)this.metrics.density);
        json.put("density_dpi", this.metrics.densityDpi);
        return json;
    }

    private JSONObject getAppJSON() throws JSONException {
        boolean needToRegisterInstall;
        JSONObject json = new JSONObject();
        this.putIfNotEmpty(json, "bundle_identifier", this.activity.getPackageName());
        try {
            Resources resources = this.activity.getResources();
            CharSequence appName = resources.getText(resources.getIdentifier("app_name", "string", this.activity.getPackageName()));
            this.putIfNotEmpty(json, "app_name", ((Object)appName).toString());
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            PackageManager pm = this.activity.getPackageManager();
            PackageInfo pkgInfo = pm.getPackageInfo(this.activity.getPackageName(), 0);
            int version = pkgInfo.versionCode;
            this.putIfNotEmpty(json, "app_version", "" + version);
            String versionName = pkgInfo.versionName;
            this.putIfNotEmpty(json, "app_version_name", versionName);
        }
        catch (Exception e) {
            // empty catch block
        }
        StoredData cache = new StoredData(this.activity);
        boolean bl = needToRegisterInstall = !cache.isAlreadyTracked();
        if (needToRegisterInstall) {
            this.putIfNotEmpty(json, "install_not_registered", "true");
        }
        return json;
    }

    public void printEnvironmentInformation(String appId) {
        RMLog.i("RevMob SDK Version: " + RevMobClient.SDK_VERSION);
        RMLog.i("App ID: " + appId);
        RMLog.i("Simulator: " + this.isSimulator());
        RMLog.i("OS Version: " + this.getOsVersion());
        RMLog.i("Android API: " + this.getApiVersion());
        RMLog.i("Manufacturer: " + this.getManufacturer());
        RMLog.i("Model: " + this.getModel());
        RMLog.i("Android ID: " + this.getAndroidID());
        RMLog.i("Mobile ID: " + this.getMobileID());
        RMLog.i("Serial number: " + this.getSerial());
        RMLog.i("MAC Address: " + this.getMACAddress());
        RMLog.i("Connection: " + this.getNetworkConnectionType());
        RMLog.i("Language: " + RevMobContext.getLanguage());
        RMLog.i("Locale: " + RevMobContext.getLocale());
        RMLog.i("User Agent: " + RevMobContext.getUserAgent());
        RMLog.i("Screen size: " + this.metrics.widthPixels + "," + this.metrics.heightPixels);
        RMLog.i("Density scale: " + this.metrics.density);
        RMLog.i("Density dpi: " + this.metrics.densityDpi);
    }

    public static String getUserAgent() {
        return System.getProperty("http.agent");
    }

    public String getMACAddress() {
        if (AndroidHelper.isPermissionEnabled(this.activity, "ACCESS_WIFI_STATE")) {
            try {
                return ((WifiManager)this.activity.getSystemService("wifi")).getConnectionInfo().getMacAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String getMobileID() {
        if (AndroidHelper.isPermissionEnabled(this.activity, "READ_PHONE_STATE")) {
            try {
                TelephonyManager tm = (TelephonyManager)this.activity.getSystemService("phone");
                if (this.isSimulator()) {
                    return "355031040373919";
                }
                return tm.getDeviceId();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSerial() {
        String serial = null;
        try {
            serial = (String)Build.class.getDeclaredField("SERIAL").get(String.class);
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return serial;
    }

    public String getAndroidID() {
        try {
            return Settings.Secure.getString((ContentResolver)this.activity.getContentResolver(), (String)"android_id");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public int getApiVersion() {
        return Build.VERSION.SDK_INT;
    }

    public String getNetworkConnectionType() {
        if (AndroidHelper.isPermissionEnabled(this.activity, "ACCESS_NETWORK_STATE")) {
            try {
                return this.networkConnection(this.activity);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isSimulator() {
        return this.getModel().contains("sdk") || this.getModel().contains("Emulator");
    }

    public static String getLocale() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    private void putIfNotEmpty(JSONObject target, String name, String value) throws JSONException {
        if (value != null && !value.equals("")) {
            target.put(name, (Object)value);
        }
    }

    private String networkConnection(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager == null) {
            return null;
        }
        if (this.isConnectedTo(manager.getNetworkInfo(0))) {
            return "wwan";
        }
        if (this.isConnectedTo(manager.getNetworkInfo(1))) {
            return "wifi";
        }
        return null;
    }

    private boolean isConnectedTo(NetworkInfo info) {
        if (info == null) {
            return false;
        }
        return info.getState() == NetworkInfo.State.CONNECTED || info.getState() == NetworkInfo.State.CONNECTING;
    }
}

