/*
 * Decompiled with CFR 0.152.
 */
package com.revmob.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import com.revmob.RevMobAdsListener;
import com.revmob.ads.fullscreen.FullscreenActivity;
import com.revmob.client.AdData;
import com.revmob.internal.LocationUrlNotFoundException;
import com.revmob.internal.MarketRedirector;
import com.revmob.internal.RMLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketAsyncManager
extends AsyncTask<Void, Void, Void> {
    private RevMobAdsListener publisherListener;
    private Activity activity;
    private AdData data;
    private MarketAsyncManagerListener listener;

    public MarketAsyncManager(Activity activity, AdData data, RevMobAdsListener publisherListener) {
        this(activity, data, publisherListener, null);
    }

    public MarketAsyncManager(Activity activity, AdData data, RevMobAdsListener publisherListener, MarketAsyncManagerListener listener) {
        this.activity = activity;
        this.publisherListener = publisherListener;
        this.data = data;
        this.listener = listener;
    }

    protected Void doInBackground(Void ... params) {
        if (this.publisherListener != null) {
            this.publisherListener.onRevMobAdClicked();
        }
        this.openAdvertisement();
        return null;
    }

    public void openAdvertisement() {
        try {
            final String marketURL = new MarketRedirector(this.data.getClickUrl()).getMarketUrl();
            boolean activityAvailable = FullscreenActivity.isFullscreenActivityAvailable(this.activity);
            if (this.data.getAppOrSite() == "site" && this.data.isOpenInside() && activityAvailable) {
                this.activity.runOnUiThread(new Runnable(){

                    public void run() {
                        Intent i = new Intent((Context)MarketAsyncManager.this.activity, FullscreenActivity.class);
                        i.putExtra("marketURL", marketURL);
                        MarketAsyncManager.this.activity.startActivityForResult(i, 0);
                    }
                });
            } else {
                this.activity.startActivity(MarketAsyncManager.createIntentThatOpensURL(marketURL));
            }
        }
        catch (LocationUrlNotFoundException e) {
            RMLog.w(String.format("Market url not found for clickUrl: %s", this.data.getClickUrl()));
            this.activity.startActivity(MarketAsyncManager.createIntentThatOpensURL(this.data.getClickUrl()));
        }
    }

    public static Intent createIntentThatOpensURL(String url) {
        return new Intent("android.intent.action.VIEW", Uri.parse((String)url));
    }

    protected void onPreExecute() {
        if (this.listener != null) {
            this.listener.onPreExecute();
        }
    }

    protected void onPostExecute(Void result) {
        if (this.listener != null) {
            this.listener.onPostExecute();
        }
    }

    public static interface MarketAsyncManagerListener {
        public void onPreExecute();

        public void onPostExecute();
    }
}

