/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.content.Context;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;

public class ContextScope
implements Scope {
    protected HashMap<Context, Map<Key<?>, Object>> scopedObjects = new HashMap();
    protected ThreadLocal<Context> contextThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Context context) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Context prev = this.contextThreadLocal.get();
            Map<Key<?>, Object> map = this.getScopedObjectMap(context);
            if (prev != null) {
                throw new IllegalArgumentException(String.format("Scope for %s must be closed before scope for %s may be opened", prev, context));
            }
            this.contextThreadLocal.set(context);
            Class<?> c = context.getClass();
            do {
                map.put(Key.get(c), context);
            } while ((c = c.getSuperclass()) != Object.class);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Context context) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Context prev = this.contextThreadLocal.get();
            if (prev != context) {
                throw new IllegalArgumentException(String.format("Scope for %s must be opened before it can be closed", context));
            }
            this.contextThreadLocal.set(null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Context context) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.contextThreadLocal.set(null);
            Map<Key<?>, Object> contextMap = this.scopedObjects.remove(context);
            contextMap.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                Class<ContextScope> clazz = ContextScope.class;
                synchronized (ContextScope.class) {
                    Context context = ContextScope.this.contextThreadLocal.get();
                    if (context != null) {
                        Map<Key<?>, Object> scopedObjects = ContextScope.this.getScopedObjectMap(context);
                        Object current = scopedObjects.get(key);
                        if (current == null && !scopedObjects.containsKey(key)) {
                            current = unscoped.get();
                            scopedObjects.put(key, current);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return current;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    throw new UnsupportedOperationException(String.format("%s is context-scoped and can't be injected outside of a context scope. Did you intend to make the referencing class @ContextSingleton or use ContextScopedProvider instead of Provider?", key.getTypeLiteral().getType()));
                }
            }
        };
    }

    protected Map<Key<?>, Object> getScopedObjectMap(Context context) {
        Map<Key<?>, Object> scopedObjects = this.scopedObjects.get(context);
        if (scopedObjects == null) {
            scopedObjects = new HashMap();
            this.scopedObjects.put(context, scopedObjects);
        }
        return scopedObjects;
    }
}

