/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeConverterBinding;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import roboguice.inject.ContextScope;
import roboguice.inject.RoboInjector;
import roboguice.inject.ViewListener;

public class ContextScopedRoboInjector
implements RoboInjector {
    protected Injector delegate;
    protected Context context;
    protected ContextScope scope;
    protected ViewListener viewListener;

    public ContextScopedRoboInjector(Context context, Injector applicationInjector, ViewListener viewListener) {
        this.delegate = applicationInjector;
        this.context = context;
        this.viewListener = viewListener;
        this.scope = (ContextScope)this.delegate.getInstance(ContextScope.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector createChildInjector(Iterable<? extends Module> modules) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Injector injector;
            this.scope.enter(this.context);
            try {
                injector = this.delegate.createChildInjector(modules);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return injector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector createChildInjector(Module ... modules) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Injector injector;
            this.scope.enter(this.context);
            try {
                injector = this.delegate.createChildInjector(modules);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return injector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            List list;
            this.scope.enter(this.context);
            try {
                list = this.delegate.findBindingsByType(type);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Key<?>, Binding<?>> getAllBindings() {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Map map;
            this.scope.enter(this.context);
            try {
                map = this.delegate.getAllBindings();
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Binding<T> getBinding(Key<T> key) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Binding binding;
            this.scope.enter(this.context);
            try {
                binding = this.delegate.getBinding(key);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return binding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Binding<T> getBinding(Class<T> type) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Binding binding;
            this.scope.enter(this.context);
            try {
                binding = this.delegate.getBinding(type);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return binding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Key<?>, Binding<?>> getBindings() {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Map map;
            this.scope.enter(this.context);
            try {
                map = this.delegate.getBindings();
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Binding<T> getExistingBinding(Key<T> key) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Binding binding;
            this.scope.enter(this.context);
            try {
                binding = this.delegate.getExistingBinding(key);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return binding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getInstance(Key<T> key) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.scope.enter(this.context);
            Object object = this.delegate.getInstance(key);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return (T)object;
            finally {
                this.scope.exit(this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getInstance(Class<T> type) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.scope.enter(this.context);
            Object object = this.delegate.getInstance(type);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return (T)object;
            finally {
                this.scope.exit(this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            MembersInjector membersInjector;
            this.scope.enter(this.context);
            try {
                membersInjector = this.delegate.getMembersInjector(type);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return membersInjector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            MembersInjector membersInjector;
            this.scope.enter(this.context);
            try {
                membersInjector = this.delegate.getMembersInjector(typeLiteral);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return membersInjector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getParent() {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Injector injector;
            this.scope.enter(this.context);
            try {
                injector = this.delegate.getParent();
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return injector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Provider<T> getProvider(Key<T> key) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Provider provider;
            this.scope.enter(this.context);
            try {
                provider = this.delegate.getProvider(key);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Provider<T> getProvider(Class<T> type) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Provider provider;
            this.scope.enter(this.context);
            try {
                provider = this.delegate.getProvider(type);
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Map map;
            this.scope.enter(this.context);
            try {
                map = this.delegate.getScopeBindings();
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TypeConverterBinding> getTypeConverterBindings() {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Set set;
            this.scope.enter(this.context);
            try {
                set = this.delegate.getTypeConverterBindings();
                this.scope.exit(this.context);
            }
            catch (Throwable throwable) {
                this.scope.exit(this.context);
                throw throwable;
            }
            return set;
        }
    }

    public void injectMembers(Object instance) {
        this.injectMembersWithoutViews(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectMembersWithoutViews(Object instance) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.scope.enter(this.context);
            try {
                this.delegate.injectMembers(instance);
            }
            finally {
                this.scope.exit(this.context);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectViewMembers(Activity activity) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.scope.enter(this.context);
            try {
                if (this.context != activity) {
                    throw new UnsupportedOperationException("internal error, how did you get here?");
                }
                ViewListener.ViewMembersInjector.injectViews(activity);
            }
            finally {
                this.scope.exit(this.context);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectViewMembers(Fragment fragment) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            this.scope.enter(this.context);
            try {
                ViewListener.ViewMembersInjector.injectViews(fragment);
            }
            finally {
                this.scope.exit(this.context);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

