/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Archive;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.Util;

class DataTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"timestamp", "date", "value"};
    private File file;
    private Object[][] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    DataTableModel() {
    }

    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int n, int n2) {
        if (this.values == null) {
            return "--";
        }
        return this.values[n][n2];
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        double d;
        assert (n2 == 2) : "Column " + n2 + " is not editable!";
        try {
            d = Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        if (this.dsIndex >= 0 && this.arcIndex >= 0 && this.file != null) {
            try {
                RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath());
                try {
                    Robin robin = rrdDb.getArchive(this.arcIndex).getRobin(this.dsIndex);
                    robin.setValue(n, d);
                    this.values[n][2] = InspectorModel.formatDouble(robin.getValue(n));
                }
                finally {
                    rrdDb.close();
                }
            }
            catch (Exception exception) {
                Util.error(null, exception);
            }
        }
    }

    void setFile(File file) {
        this.file = file;
        this.setIndex(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int n, int n2) {
        if (this.dsIndex != n || this.arcIndex != n2) {
            this.dsIndex = n;
            this.arcIndex = n2;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Archive archive = rrdDb.getArchive(this.arcIndex);
                        Robin robin = archive.getRobin(this.dsIndex);
                        long l = archive.getStartTime();
                        long l2 = archive.getArcStep();
                        double[] dArray = robin.getValues();
                        this.values = new Object[dArray.length][];
                        for (int i = 0; i < dArray.length; ++i) {
                            long l3 = l + (long)i * l2;
                            String string = new Date(l3 * 1000L).toString();
                            String string2 = InspectorModel.formatDouble(dArray[i]);
                            this.values[i] = new Object[]{"" + l3, string, string2};
                        }
                    }
                    finally {
                        rrdDb.close();
                    }
                }
                catch (IOException iOException) {
                    Util.error(null, iOException);
                }
                catch (RrdException rrdException) {
                    Util.error(null, rrdException);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

