package net.iowaline.dotdash;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

@SuppressLint("ClickableViewAccessibility")
public class DotDashKeyboardView extends KeyboardView {

	private DotDashIMEService service;
	private Dialog cheatsheetDialog;
	private TableLayout cheatsheet1;
	private TableLayout cheatsheet2;
	private int mSwipeThreshold;

	public static final int KBD_NONE = 0;
	public static final int KBD_DOTDASH = 1;
	public static final int KBD_UTILITY = 2;

	public boolean mEnableUtilityKeyboard = false;

	public void setService(DotDashIMEService service) {
		this.service = service;
	}

	public DotDashKeyboardView(Context context, AttributeSet attrs) {
		super(context, attrs);
		setEverythingUp();
	}

	public DotDashKeyboardView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		setEverythingUp();
	}

	private void setEverythingUp() {
		mSwipeThreshold = (int) (300 * getResources().getDisplayMetrics().density);
		setPreviewEnabled(false);
		@SuppressWarnings("deprecation")
		final GestureDetector gestureDetector = new GestureDetector(
				new GestureDetector.SimpleOnGestureListener() {

					/**
					 * This function mostly copied from LatinKeyboardBaseView in
					 * the Hacker's Keyboard project: http://code.google.com/p/hackerskeyboard/
					 * 
				 	 * Copyright (C) 2010, authors of the Hacker's Keyboard project: http://code.google.com/p/hackerskeyboard/ 
				 	 * Copyright (c) 2011, Aaron Wells
					 * 
					 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
					 * use this file except in compliance with the License. You may obtain a copy of
					 * the License at
					 *
					 * http://www.apache.org/licenses/LICENSE-2.0
					 */
					@Override
					public boolean onFling(MotionEvent e1, MotionEvent e2,
							float velocityX, float velocityY) {

						// If they swipe up off the keyboard, launch the cheat
						// sheet. This was originally a check for e2.getY() < 0,
						// but that didn't work in ICS. Possibly ICS stops
						// sending you events after you go past the edge of the
						// window. So I changed it to 10 instead.
						if (e2.getY() <= 10) {
							// If they swipe up off the keyboard, launch the
							// cheat sheet
							showCheatSheet();
							return true;
						} else if (mEnableUtilityKeyboard) {
							final float absX = Math.abs(velocityX);
							final float absY = Math.abs(velocityY);
							float deltaX = e2.getX() - e1.getX();
							int travelMin = Math.min((getWidth() / 3),
									(getHeight() / 3));

							if (velocityX > mSwipeThreshold && absY < absX
									&& deltaX > travelMin) {
								toggleKeyboard();
								return true;
							} else if (velocityX < -mSwipeThreshold
									&& absY < absX && deltaX < -travelMin) {
								toggleKeyboard();
								return true;
							}
						}
						return false;
					}
				});
		View.OnTouchListener gestureListener = new View.OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				if (gestureDetector.onTouchEvent(event)) {
					// Tell the underlying keyboardview to cancel its
					// touch event if we've initiated a gesture.
					MotionEvent cancel = MotionEvent.obtain(event);
					cancel.setAction(MotionEvent.ACTION_CANCEL);
					DotDashKeyboardView.this.onTouchEvent(cancel);
					cancel.recycle();
					return true;
				} else {
					return false;
				}
			}
		};
		setOnTouchListener(gestureListener);
	}

	private void toggleKeyboard() {
		if (getKeyboard() == service.dotDashKeyboard) {
			setKeyboard(service.utilityKeyboard);
			// TODO: Make this work. I think it's a layout issue...
//			setPreviewEnabled(true);
		} else {
			setKeyboard(service.dotDashKeyboard);
//			setPreviewEnabled(false);
		}
	}

	@SuppressLint("InflateParams")
	public void createCheatSheet() {
		boolean updateTouchListeners = false;
		if (this.cheatsheetDialog == null) {
			this.cheatsheetDialog = new Dialog(this.service);

			cheatsheetDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);

			cheatsheetDialog.setCancelable(true);
			cheatsheetDialog.setCanceledOnTouchOutside(true);
			updateTouchListeners = true;
		}
		if (this.cheatsheet1 == null) {
			this.cheatsheet1 = (TableLayout) this.service.getLayoutInflater().inflate(
					R.layout.cheatsheet1, null);
			this.prettifyCheatSheet(this.cheatsheet1);
			updateTouchListeners = true;
		}
		if (this.cheatsheet2 == null) {
			this.cheatsheet2 = (TableLayout) this.service.getLayoutInflater().inflate(
					R.layout.cheatsheet2, null);
			updateNewlineCode();
			this.prettifyCheatSheet(this.cheatsheet2);
			updateTouchListeners = true;
		}
		
		if (updateTouchListeners) {
			cheatsheetDialog.setContentView(cheatsheet1);
			cheatsheet1.setOnTouchListener(new OnTouchListener() {
				@Override
				public boolean onTouch(View v, MotionEvent event) {
					cheatsheetDialog.setContentView(cheatsheet2);
					return true;
				}
			});
			cheatsheet2.setOnTouchListener(new OnTouchListener() {
				@Override
				public boolean onTouch(View v, MotionEvent event) {
					cheatsheetDialog.setContentView(cheatsheet1);
					return true;
				}
			});
			Window window = this.cheatsheetDialog.getWindow();
			WindowManager.LayoutParams lp = window.getAttributes();
			lp.token = this.getWindowToken();
			lp.type = WindowManager.LayoutParams.TYPE_APPLICATION_ATTACHED_DIALOG;
			window.setAttributes(lp);
			window.addFlags(WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM);
		}
	}
	
	/**
	 * Update the characters in the cheat sheet dialogue to match the user's preference
	 * @TODO: Probably better performance if I replaced this with two hard-coded versions
	 * of the sheet...
	 * 
	 * @param cheatsheet
	 */
	public void prettifyCheatSheet(TableLayout cheatsheet) {
		// No action necessary.
		if (service.ditdahcharsPref == DotDashIMEService.DITDAHCHARS_UNICODE) {
			return;
		}
		
		for (int i = 0; i < cheatsheet.getChildCount(); i++) {
			TableRow row = (TableRow) cheatsheet.getChildAt(i);
			
			// On my cheat sheets, only the even-number columns
			// contain code groups
			for (int j = 1; j < row.getChildCount(); j += 2) {
				TextView cell = (TextView) row.getChildAt(j);
				cell.setText(service.convertDitDahUnicodeToAscii(cell.getText().toString(), true));
			}
		}
	}

	public void showCheatSheet() {
		createCheatSheet();
		cheatsheetDialog.show();
	}
	
	public void closeCheatSheet() {
		if (cheatsheetDialog != null) {
			cheatsheetDialog.dismiss();
		}
	}
	
	public void clearCheatSheet() {
		closeCheatSheet();
		this.cheatsheet1 = null;
		this.cheatsheet2 = null;
	}

	/**
	 * Updates the newline code printed in the cheat sheet, based on the user's
	 * current preference.
	 */
	public void updateNewlineCode() {
		if (cheatsheet2 == null) {
			return;
		}

		String newCode = service.getText(R.string.newline_disabled).toString();
		if (service.newlineGroups != null && service.newlineGroups.length > 0) {
			newCode = service.newlineGroups[0].replace(".", DotDashIMEService.UNICODE_DOT).replace("-",  DotDashIMEService.UNICODE_DASH);
		}
		((TextView) cheatsheet2.findViewById(R.id.newline_code))
				.setText(newCode);
	}

	public int whichKeyboard() {
		Keyboard kbd = getKeyboard();
		if (kbd == service.dotDashKeyboard) {
			return KBD_DOTDASH;
		} else if (kbd == service.utilityKeyboard) {
			return KBD_UTILITY;
		} else
			return KBD_NONE;
	}
}
