/**
 * Copyright (C) 2009 SC 4ViewSoft SRL
 * Copyright (C) 2009 Cyril Jaquier
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.achartengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * A series for the category charts like the bar and pie ones.
 */
public class CategorySeries implements Serializable {
	/** The series title. */
	private final String mTitle;
	/** The series keys. */
	private final List<String> mKeys = new ArrayList<String>();
	/** The series values. */
	private final List<Double> mValues = new ArrayList<Double>();

	/**
	 * Builds a new category series.
	 * 
	 * @param title
	 *            the series title
	 */
	public CategorySeries(String title) {
		mTitle = title;
	}

	/**
	 * Returns the series title.
	 * 
	 * @return the series title
	 */
	public String getTitle() {
		return mTitle;
	}

	/**
	 * Adds a new value to the series
	 * 
	 * @param value
	 *            the new value
	 */
	public void add(double value) {
		mKeys.add(mKeys.size() + "");
		mValues.add(value);
	}

	/**
	 * Adds a new value to the series.
	 * 
	 * @param key
	 *            the key
	 * @param value
	 *            the new value
	 */
	public void add(String key, double value) {
		mKeys.add(key);
		mValues.add(value);
	}

	/**
	 * Returns the value at the specified index.
	 * 
	 * @param index
	 *            the index
	 * @return the value at the index
	 */
	public double getValue(int index) {
		return mValues.get(index);
	}

	/**
	 * Returns the category name at the specified index.
	 * 
	 * @param index
	 *            the index
	 * @return the category name at the index
	 */
	public String getCategory(int index) {
		return mKeys.get(index);
	}

	/**
	 * Returns the series item count.
	 * 
	 * @return the series item count
	 */
	public int getItemCount() {
		return mValues.size();
	}

	/**
	 * Transforms the category series to an XY series.
	 * 
	 * @return the XY series
	 */
	public XYSeries toXYSeries() {
		XYSeries xySeries = new XYSeries(mTitle);
		int k = 0;
		for (double value : mValues) {
			xySeries.add(++k, value);
		}
		return xySeries;
	}
}
