/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;

public abstract class TileLooper {
    protected final Point mUpperLeft = new Point();
    protected final Point mLowerRight = new Point();

    public final void loop(Canvas pCanvas, int pZoomLevel, int pTileSizePx, Rect pViewPort) {
        TileSystem.PixelXYToTileXY(pViewPort.left, pViewPort.top, this.mUpperLeft);
        this.mUpperLeft.offset(-1, -1);
        TileSystem.PixelXYToTileXY(pViewPort.right, pViewPort.bottom, this.mLowerRight);
        int mapTileUpperBound = 1 << pZoomLevel;
        this.initialiseLoop(pZoomLevel, pTileSizePx);
        for (int y = this.mUpperLeft.y; y <= this.mLowerRight.y; ++y) {
            for (int x = this.mUpperLeft.x; x <= this.mLowerRight.x; ++x) {
                int tileY = MyMath.mod(y, mapTileUpperBound);
                int tileX = MyMath.mod(x, mapTileUpperBound);
                MapTile tile = new MapTile(pZoomLevel, tileX, tileY);
                this.handleTile(pCanvas, pTileSizePx, tile, x, y);
            }
        }
        this.finaliseLoop();
    }

    public abstract void initialiseLoop(int var1, int var2);

    public abstract void handleTile(Canvas var1, int var2, MapTile var3, int var4, int var5);

    public abstract void finaliseLoop();
}

