/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Map;
import java.util.TreeMap;
import org.acra.ACRA;

final class SharedPreferencesCollector {
    SharedPreferencesCollector() {
    }

    public static String collect(Context context) {
        StringBuilder result = new StringBuilder();
        TreeMap<String, SharedPreferences> shrdPrefs = new TreeMap<String, SharedPreferences>();
        shrdPrefs.put("default", PreferenceManager.getDefaultSharedPreferences((Context)context));
        String[] shrdPrefsIds = ACRA.getConfig().additionalSharedPreferences();
        if (shrdPrefsIds != null) {
            for (String shrdPrefId : shrdPrefsIds) {
                shrdPrefs.put(shrdPrefId, context.getSharedPreferences(shrdPrefId, 0));
            }
        }
        for (String prefsId : shrdPrefs.keySet()) {
            result.append(prefsId).append("\n");
            SharedPreferences prefs = (SharedPreferences)shrdPrefs.get(prefsId);
            if (prefs != null) {
                Map kv = prefs.getAll();
                if (kv != null && kv.size() > 0) {
                    for (String key : kv.keySet()) {
                        if (SharedPreferencesCollector.filteredKey(key)) continue;
                        if (kv.get(key) != null) {
                            result.append(key).append("=").append(kv.get(key).toString()).append("\n");
                            continue;
                        }
                        result.append(key).append("=").append("null\n");
                    }
                } else {
                    result.append("empty\n");
                }
            } else {
                result.append("null\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static boolean filteredKey(String key) {
        int i$ = 0;
        String[] arr$ = ACRA.getConfig().excludeMatchingSharedPreferencesKeys();
        int len$ = arr$.length;
        if (i$ < len$) {
            String regex = arr$[i$];
            return key.matches(regex);
        }
        return false;
    }
}

