/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jcajce.provider.symmetric.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.Mac;
import org.spongycastle.crypto.digests.MD2Digest;
import org.spongycastle.crypto.digests.MD4Digest;
import org.spongycastle.crypto.digests.MD5Digest;
import org.spongycastle.crypto.digests.RIPEMD128Digest;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.digests.TigerDigest;
import org.spongycastle.crypto.engines.DESEngine;
import org.spongycastle.crypto.engines.RC2Engine;
import org.spongycastle.crypto.macs.CBCBlockCipherMac;
import org.spongycastle.crypto.macs.CFBBlockCipherMac;
import org.spongycastle.crypto.macs.GOST28147Mac;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.crypto.macs.ISO9797Alg3Mac;
import org.spongycastle.crypto.macs.OldHMac;
import org.spongycastle.crypto.paddings.BlockCipherPadding;
import org.spongycastle.crypto.paddings.ISO7816d4Padding;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.jcajce.provider.symmetric.util.BCPBEKey;
import org.spongycastle.jcajce.provider.symmetric.util.PBE;

public class BaseMac
extends MacSpi
implements PBE {
    private Mac macEngine;
    private int pbeType = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected BaseMac(Mac macEngine) {
        this.macEngine = macEngine;
    }

    protected BaseMac(Mac macEngine, int pbeType, int pbeHash, int keySize) {
        this.macEngine = macEngine;
        this.pbeType = pbeType;
        this.pbeHash = pbeHash;
        this.keySize = keySize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof BCPBEKey) {
            BCPBEKey k = (BCPBEKey)key;
            if (k.getParam() != null) {
                param = k.getParam();
            } else {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                param = PBE.Util.makePBEMacParameters(k, params);
            }
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV((CipherParameters)new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
        } else {
            if (params != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            param = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(param);
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte input) {
        this.macEngine.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macEngine.update(input, offset, len);
    }

    protected byte[] engineDoFinal() {
        byte[] out = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(out, 0);
        return out;
    }

    public static class PBEWithTiger
    extends BaseMac {
        public PBEWithTiger() {
            super((Mac)new HMac((Digest)new TigerDigest()), 2, 3, 192);
        }
    }

    public static class PBEWithSHA
    extends BaseMac {
        public PBEWithSHA() {
            super((Mac)new HMac((Digest)new SHA1Digest()), 2, 1, 160);
        }
    }

    public static class PBEWithRIPEMD160
    extends BaseMac {
        public PBEWithRIPEMD160() {
            super((Mac)new HMac((Digest)new RIPEMD160Digest()), 2, 2, 160);
        }
    }

    public static class Tiger
    extends BaseMac {
        public Tiger() {
            super((Mac)new HMac((Digest)new TigerDigest()));
        }
    }

    public static class RIPEMD160
    extends BaseMac {
        public RIPEMD160() {
            super((Mac)new HMac((Digest)new RIPEMD160Digest()));
        }
    }

    public static class RIPEMD128
    extends BaseMac {
        public RIPEMD128() {
            super((Mac)new HMac((Digest)new RIPEMD128Digest()));
        }
    }

    public static class OldSHA512
    extends BaseMac {
        public OldSHA512() {
            super((Mac)new OldHMac((Digest)new SHA512Digest()));
        }
    }

    public static class SHA512
    extends BaseMac {
        public SHA512() {
            super((Mac)new HMac((Digest)new SHA512Digest()));
        }
    }

    public static class OldSHA384
    extends BaseMac {
        public OldSHA384() {
            super((Mac)new OldHMac((Digest)new SHA384Digest()));
        }
    }

    public static class SHA384
    extends BaseMac {
        public SHA384() {
            super((Mac)new HMac((Digest)new SHA384Digest()));
        }
    }

    public static class SHA256
    extends BaseMac {
        public SHA256() {
            super((Mac)new HMac((Digest)new SHA256Digest()));
        }
    }

    public static class SHA224
    extends BaseMac {
        public SHA224() {
            super((Mac)new HMac((Digest)new SHA224Digest()));
        }
    }

    public static class SHA1
    extends BaseMac {
        public SHA1() {
            super((Mac)new HMac((Digest)new SHA1Digest()));
        }
    }

    public static class MD5
    extends BaseMac {
        public MD5() {
            super((Mac)new HMac((Digest)new MD5Digest()));
        }
    }

    public static class MD4
    extends BaseMac {
        public MD4() {
            super((Mac)new HMac((Digest)new MD4Digest()));
        }
    }

    public static class MD2
    extends BaseMac {
        public MD2() {
            super((Mac)new HMac((Digest)new MD2Digest()));
        }
    }

    public static class DES9797Alg3
    extends BaseMac {
        public DES9797Alg3() {
            super((Mac)new ISO9797Alg3Mac((BlockCipher)new DESEngine()));
        }
    }

    public static class DES9797Alg3with7816d4
    extends BaseMac {
        public DES9797Alg3with7816d4() {
            super((Mac)new ISO9797Alg3Mac((BlockCipher)new DESEngine(), (BlockCipherPadding)new ISO7816d4Padding()));
        }
    }

    public static class RC2CFB8
    extends BaseMac {
        public RC2CFB8() {
            super((Mac)new CFBBlockCipherMac((BlockCipher)new RC2Engine()));
        }
    }

    public static class DESCFB8
    extends BaseMac {
        public DESCFB8() {
            super((Mac)new CFBBlockCipherMac((BlockCipher)new DESEngine()));
        }
    }

    public static class GOST28147
    extends BaseMac {
        public GOST28147() {
            super((Mac)new GOST28147Mac());
        }
    }

    public static class RC2
    extends BaseMac {
        public RC2() {
            super((Mac)new CBCBlockCipherMac((BlockCipher)new RC2Engine()));
        }
    }

    public static class DES64
    extends BaseMac {
        public DES64() {
            super((Mac)new CBCBlockCipherMac((BlockCipher)new DESEngine(), 64));
        }
    }

    public static class DES
    extends BaseMac {
        public DES() {
            super((Mac)new CBCBlockCipherMac((BlockCipher)new DESEngine()));
        }
    }
}

