/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cert.ocsp;

import java.io.IOException;
import org.spongycastle.asn1.ASN1Exception;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ocsp.BasicOCSPResponse;
import org.spongycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.spongycastle.asn1.ocsp.OCSPResponse;
import org.spongycastle.asn1.ocsp.ResponseBytes;
import org.spongycastle.cert.CertIOException;
import org.spongycastle.cert.ocsp.BasicOCSPResp;
import org.spongycastle.cert.ocsp.OCSPException;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance((Object)aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ASN1Exception e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals((Object)OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)obj));
            }
            catch (Exception e) {
                throw new OCSPException("problem decoding object: " + e, e);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r = (OCSPResp)o;
        return this.resp.equals((Object)r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

