/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.cms.PasswordRecipientInfo;
import org.spongycastle.asn1.pkcs.PBKDF2Params;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.AuthAttributesProvider;
import org.spongycastle.cms.CMSAlgorithm;
import org.spongycastle.cms.CMSEnvelopedHelper;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSPBEKey;
import org.spongycastle.cms.CMSSecureReadable;
import org.spongycastle.cms.CMSTypedStream;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.PKCS5Scheme2UTF8PBEKey;
import org.spongycastle.cms.PasswordRecipient;
import org.spongycastle.cms.PasswordRecipientId;
import org.spongycastle.cms.Recipient;
import org.spongycastle.cms.RecipientInformation;
import org.spongycastle.cms.RecipientOperator;
import org.spongycastle.cms.jcajce.JceAlgorithmIdentifierConverter;
import org.spongycastle.cms.jcajce.JcePasswordAuthenticatedRecipient;
import org.spongycastle.cms.jcajce.JcePasswordEnvelopedRecipient;
import org.spongycastle.cms.jcajce.JcePasswordRecipient;
import org.spongycastle.crypto.PBEParametersGenerator;
import org.spongycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.spongycastle.crypto.params.KeyParameter;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            ASN1Encodable params;
            if (this.info.getKeyDerivationAlgorithm() != null && (params = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return params.toASN1Primitive().getEncoded();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.info.getKeyDerivationAlgorithm();
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(String provider) throws NoSuchProviderException {
        return this.getKeyDerivationAlgParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(Provider provider) {
        try {
            return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.info.getKeyDerivationAlgorithm());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            CMSPBEKey pbeKey = (CMSPBEKey)key;
            JcePasswordRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JcePasswordEnvelopedRecipient(pbeKey.getPassword()) : new JcePasswordAuthenticatedRecipient(pbeKey.getPassword());
            recipient.setPasswordConversionScheme(pbeKey instanceof PKCS5Scheme2UTF8PBEKey ? 1 : 0);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        PasswordRecipient pbeRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance((Object)this.info.getKeyEncryptionAlgorithm());
        AlgorithmIdentifier kekAlgParams = AlgorithmIdentifier.getInstance((Object)kekAlg.getParameters());
        byte[] passwordBytes = this.getPasswordBytes(pbeRecipient.getPasswordConversionScheme(), pbeRecipient.getPassword());
        PBKDF2Params params = PBKDF2Params.getInstance((Object)this.info.getKeyDerivationAlgorithm().getParameters());
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwordBytes, params.getSalt(), params.getIterationCount().intValue());
        int keySize = (Integer)KEYSIZES.get(kekAlgParams.getAlgorithm());
        byte[] derivedKey = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        return pbeRecipient.getRecipientOperator(kekAlgParams, this.messageAlgorithm, derivedKey, this.info.getEncryptedKey().getOctets());
    }

    protected byte[] getPasswordBytes(int scheme, char[] password) {
        if (scheme == 0) {
            return PBEParametersGenerator.PKCS5PasswordToBytes((char[])password);
        }
        return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])password);
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(256));
    }
}

