/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.spongycastle.crypto.tls.DefaultTlsCipherFactory;
import org.spongycastle.crypto.tls.ProtocolVersion;
import org.spongycastle.crypto.tls.TlsAuthentication;
import org.spongycastle.crypto.tls.TlsCipher;
import org.spongycastle.crypto.tls.TlsCipherFactory;
import org.spongycastle.crypto.tls.TlsClient;
import org.spongycastle.crypto.tls.TlsClientContext;
import org.spongycastle.crypto.tls.TlsCompression;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsKeyExchange;
import org.spongycastle.crypto.tls.TlsNullCompression;
import org.spongycastle.crypto.tls.TlsPSKIdentity;
import org.spongycastle.crypto.tls.TlsPSKKeyExchange;

public class PSKTlsClient
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsPSKIdentity pskIdentity;
    protected TlsClientContext context;
    protected int selectedCompressionMethod;
    protected int selectedCipherSuite;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        this.cipherFactory = cipherFactory;
        this.pskIdentity = pskIdentity;
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv10;
    }

    public void init(TlsClientContext context) {
        this.context = context;
    }

    public int[] getCipherSuites() {
        return new int[]{145, 144, 143, 149, 148, 147, 141, 140, 139};
    }

    public Hashtable getClientExtensions() throws IOException {
        return null;
    }

    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!ProtocolVersion.TLSv10.equals(serverVersion)) {
            throw new TlsFatalAlert(47);
        }
    }

    public void notifySessionID(byte[] sessionID) {
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            // empty if block
        }
    }

    public void processServerExtensions(Hashtable serverExtensions) {
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 139: 
            case 140: 
            case 141: {
                return this.createPSKKeyExchange(13);
            }
            case 147: 
            case 148: 
            case 149: {
                return this.createPSKKeyExchange(15);
            }
            case 143: 
            case 144: 
            case 145: {
                return this.createPSKKeyExchange(14);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return null;
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 139: 
            case 143: 
            case 147: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 140: 
            case 144: 
            case 148: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 141: 
            case 145: 
            case 149: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(this.context, keyExchange, this.pskIdentity);
    }
}

