/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleChainVisitor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.ast.CompilationUnit;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.util.Benchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleChainVisitor
implements RuleChainVisitor {
    protected Map<RuleSet, List<Rule>> ruleSetRules = new LinkedHashMap<RuleSet, List<Rule>>();
    protected Map<String, List<SimpleNode>> nodeNameToNodes;

    @Override
    public void add(RuleSet ruleSet, Rule rule) {
        if (!this.ruleSetRules.containsKey(ruleSet)) {
            this.ruleSetRules.put(ruleSet, new ArrayList());
        }
        this.ruleSetRules.get(ruleSet).add(rule);
    }

    @Override
    public void visitAll(List<CompilationUnit> astCompilationUnits, RuleContext ctx) {
        this.initialize();
        this.clear();
        long start = System.nanoTime();
        this.indexNodes(astCompilationUnits, ctx);
        long end = System.nanoTime();
        Benchmark.mark(8, end - start, 1L);
        for (RuleSet ruleSet : this.ruleSetRules.keySet()) {
            if (!ruleSet.applies(ctx.getSourceCodeFile())) continue;
            start = System.nanoTime();
            for (Rule rule : this.ruleSetRules.get(ruleSet)) {
                int visits = 0;
                List<String> nodeNames = rule.getRuleChainVisits();
                for (int j = 0; j < nodeNames.size(); ++j) {
                    List<SimpleNode> nodes = this.nodeNameToNodes.get(nodeNames.get(j));
                    for (SimpleNode node : nodes) {
                        while (rule instanceof RuleReference) {
                            rule = ((RuleReference)rule).getRule();
                        }
                        this.visit(rule, node, ctx);
                    }
                    visits += nodes.size();
                }
                end = System.nanoTime();
                Benchmark.mark(1, rule.getName(), end - start, visits);
                start = end;
            }
        }
    }

    protected abstract void visit(Rule var1, SimpleNode var2, RuleContext var3);

    protected abstract void indexNodes(List<CompilationUnit> var1, RuleContext var2);

    protected void indexNode(SimpleNode node) {
        List<SimpleNode> nodes = this.nodeNameToNodes.get(node.toString());
        if (nodes != null) {
            nodes.add(node);
        }
    }

    protected void initialize() {
        if (this.nodeNameToNodes != null) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        Iterator<Map.Entry<RuleSet, List<Rule>>> entryIterator = this.ruleSetRules.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<RuleSet, List<Rule>> entry = entryIterator.next();
            Iterator<Rule> ruleIterator = entry.getValue().iterator();
            while (ruleIterator.hasNext()) {
                Rule rule = ruleIterator.next();
                if (rule.usesRuleChain()) {
                    visitedNodes.addAll(rule.getRuleChainVisits());
                    continue;
                }
                ruleIterator.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            entryIterator.remove();
        }
        this.nodeNameToNodes = new HashMap<String, List<SimpleNode>>();
        for (String s : visitedNodes) {
            ArrayList nodes = new ArrayList(100);
            this.nodeNameToNodes.put(s, nodes);
        }
    }

    protected void clear() {
        for (List<SimpleNode> l : this.nodeNameToNodes.values()) {
            l.clear();
        }
    }
}

