/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRenderer
implements Renderer {
    private String encoding;
    public static final String[][] BASIC_ESCAPE = new String[][]{{"\"", "&quot;"}, {"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};

    public XMLRenderer() {
        this(System.getProperty("file.encoding"));
    }

    public XMLRenderer(String e) {
        this.encoding = e;
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("<?xml version=\"1.0\" encoding=\"");
        buffer.append(this.encoding);
        buffer.append("\"?>").append(PMD.EOL);
        buffer.append("<pmd-cpd>").append(PMD.EOL);
        while (matches.hasNext()) {
            Match match = matches.next();
            buffer.append("<duplication lines=\"");
            buffer.append(match.getLineCount());
            buffer.append("\" tokens=\"");
            buffer.append(match.getTokenCount());
            buffer.append("\">").append(PMD.EOL);
            Iterator<TokenEntry> iterator = match.iterator();
            while (iterator.hasNext()) {
                TokenEntry mark = iterator.next();
                buffer.append("<file line=\"");
                buffer.append(mark.getBeginLine());
                buffer.append("\" path=\"");
                buffer.append(XMLRenderer.encode(mark.getTokenSrcID()));
                buffer.append("\"/>").append(PMD.EOL);
            }
            String codeFragment = match.getSourceCodeSlice();
            if (codeFragment != null) {
                buffer.append("<codefragment>").append(PMD.EOL);
                buffer.append("<![CDATA[").append(PMD.EOL);
                buffer.append(StringUtil.replaceString(codeFragment, "]]>", "]]&gt;")).append(PMD.EOL + "]]>" + PMD.EOL + "</codefragment>" + PMD.EOL);
            }
            buffer.append("</duplication>").append(PMD.EOL);
        }
        buffer.append("</pmd-cpd>");
        return buffer.toString();
    }

    private static String encode(String path) {
        for (int i = 0; i < BASIC_ESCAPE.length; ++i) {
            if (path.indexOf(BASIC_ESCAPE[i][0]) == -1) continue;
            path = path.replaceAll(BASIC_ESCAPE[i][0], BASIC_ESCAPE[i][1]);
        }
        return path;
    }
}

