/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRenderer
extends OnTheFlyRenderer {
    protected String encoding = "UTF-8";

    @Override
    public void start() throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>").append(PMD.EOL);
        this.createVersionAttr(buf);
        this.createTimestampAttr(buf);
        buf.append('>').append(PMD.EOL);
        writer.write(buf.toString());
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        String filename = null;
        while (violations.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = violations.next();
            if (!rv.getFilename().equals(filename)) {
                if (filename != null) {
                    buf.append("</file>").append(PMD.EOL);
                }
                filename = rv.getFilename();
                buf.append("<file name=\"");
                StringUtil.appendXmlEscaped(buf, filename);
                buf.append("\">").append(PMD.EOL);
            }
            buf.append("<violation beginline=\"").append(rv.getBeginLine());
            buf.append("\" endline=\"").append(rv.getEndLine());
            buf.append("\" begincolumn=\"").append(rv.getBeginColumn());
            buf.append("\" endcolumn=\"").append(rv.getEndColumn());
            buf.append("\" rule=\"");
            StringUtil.appendXmlEscaped(buf, rv.getRule().getName());
            buf.append("\" ruleset=\"");
            StringUtil.appendXmlEscaped(buf, rv.getRule().getRuleSetName());
            buf.append('\"');
            this.maybeAdd("package", rv.getPackageName(), buf);
            this.maybeAdd("class", rv.getClassName(), buf);
            this.maybeAdd("method", rv.getMethodName(), buf);
            this.maybeAdd("variable", rv.getVariableName(), buf);
            this.maybeAdd("externalInfoUrl", rv.getRule().getExternalInfoUrl(), buf);
            buf.append(" priority=\"");
            buf.append(rv.getRule().getPriority());
            buf.append("\">").append(PMD.EOL);
            StringUtil.appendXmlEscaped(buf, rv.getDescription());
            buf.append(PMD.EOL);
            buf.append("</violation>");
            buf.append(PMD.EOL);
            writer.write(buf.toString());
        }
        if (filename != null) {
            writer.write("</file>");
            writer.write(PMD.EOL);
        }
    }

    @Override
    public void end() throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        for (Report.ProcessingError pe : this.errors) {
            buf.setLength(0);
            buf.append("<error ").append("filename=\"");
            StringUtil.appendXmlEscaped(buf, pe.getFile());
            buf.append("\" msg=\"");
            StringUtil.appendXmlEscaped(buf, pe.getMsg());
            buf.append("\"/>").append(PMD.EOL);
            writer.write(buf.toString());
        }
        if (this.showSuppressedViolations) {
            for (Report.SuppressedViolation s : this.suppressed) {
                buf.setLength(0);
                buf.append("<suppressedviolation ").append("filename=\"");
                StringUtil.appendXmlEscaped(buf, s.getRuleViolation().getFilename());
                buf.append("\" suppressiontype=\"");
                StringUtil.appendXmlEscaped(buf, s.suppressedByNOPMD() ? "nopmd" : "annotation");
                buf.append("\" msg=\"");
                StringUtil.appendXmlEscaped(buf, s.getRuleViolation().getDescription());
                buf.append("\" usermsg=\"");
                StringUtil.appendXmlEscaped(buf, s.getUserMessage() == null ? "" : s.getUserMessage());
                buf.append("\"/>").append(PMD.EOL);
                writer.write(buf.toString());
            }
        }
        writer.write("</pmd>");
    }

    private void maybeAdd(String attr, String value, StringBuffer buf) {
        if (value != null && value.length() > 0) {
            buf.append(' ').append(attr).append("=\"");
            StringUtil.appendXmlEscaped(buf, value);
            buf.append('\"');
        }
    }

    private void createVersionAttr(StringBuffer buffer) {
        buffer.append("<pmd version=\"").append("4.2.6").append('\"');
    }

    private void createTimestampAttr(StringBuffer buffer) {
        buffer.append(" timestamp=\"").append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date())).append('\"');
    }

    private String createTimeElapsedAttr(Report rpt) {
        Report.ReadableDuration d = new Report.ReadableDuration(rpt.getElapsedTimeInMillis());
        return " elapsedTime=\"" + d.getTime() + "\"";
    }
}

