/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;

public class DoubleCheckedLocking
extends AbstractJavaRule {
    private List<String> volatileFields;

    public Object visit(ASTCompilationUnit compilationUnit, Object data) {
        if (this.volatileFields == null) {
            this.volatileFields = new ArrayList<String>(0);
        } else {
            this.volatileFields.clear();
        }
        return super.visit(compilationUnit, data);
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (fieldDeclaration.isVolatile()) {
            for (ASTVariableDeclaratorId declarator : fieldDeclaration.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                this.volatileFields.add(declarator.getImage());
            }
        }
        return super.visit(fieldDeclaration, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTIfStatement is;
        if (node.getResultType().isVoid()) {
            return super.visit(node, data);
        }
        ASTType typeNode = (ASTType)node.getResultType().jjtGetChild(0);
        if (typeNode.jjtGetNumChildren() == 0 || !(typeNode.jjtGetChild(0) instanceof ASTReferenceType)) {
            return super.visit(node, data);
        }
        ArrayList rsl = new ArrayList();
        node.findChildrenOfType(ASTReturnStatement.class, rsl, true);
        if (rsl.size() != 1) {
            return super.visit(node, data);
        }
        ASTReturnStatement rs = (ASTReturnStatement)rsl.get(0);
        ArrayList pel = new ArrayList();
        rs.findChildrenOfType(ASTPrimaryExpression.class, pel, true);
        ASTPrimaryExpression ape = (ASTPrimaryExpression)pel.get(0);
        Node lastChild = ape.jjtGetChild(ape.jjtGetNumChildren() - 1);
        String returnVariableName = null;
        if (lastChild instanceof ASTPrimaryPrefix) {
            returnVariableName = this.getNameFromPrimaryPrefix((ASTPrimaryPrefix)lastChild);
        }
        if (returnVariableName == null || this.volatileFields.contains(returnVariableName)) {
            return super.visit(node, data);
        }
        ArrayList isl = new ArrayList();
        node.findChildrenOfType(ASTIfStatement.class, isl, true);
        if (isl.size() == 2 && this.ifVerify(is = (ASTIfStatement)isl.get(0), returnVariableName)) {
            ArrayList ssl = new ArrayList();
            is.findChildrenOfType(ASTSynchronizedStatement.class, ssl, true);
            if (ssl.size() == 1) {
                ASTIfStatement is2;
                ASTSynchronizedStatement ss = (ASTSynchronizedStatement)ssl.get(0);
                isl.clear();
                ss.findChildrenOfType(ASTIfStatement.class, isl, true);
                if (isl.size() == 1 && this.ifVerify(is2 = (ASTIfStatement)isl.get(0), returnVariableName)) {
                    ASTPrimaryExpression pe;
                    ASTStatementExpression se;
                    ArrayList sel = new ArrayList();
                    is2.findChildrenOfType(ASTStatementExpression.class, sel, true);
                    if (sel.size() == 1 && (se = (ASTStatementExpression)sel.get(0)).jjtGetNumChildren() == 3 && se.jjtGetChild(0) instanceof ASTPrimaryExpression && this.matchName(pe = (ASTPrimaryExpression)se.jjtGetChild(0), returnVariableName) && se.jjtGetChild(1) instanceof ASTAssignmentOperator) {
                        this.addViolation(data, node);
                    }
                }
            }
        }
        return super.visit(node, data);
    }

    private boolean ifVerify(ASTIfStatement is, String varname) {
        ASTLiteral lit;
        ASTPrimaryPrefix pp2;
        ASTPrimaryExpression nullStmt;
        ArrayList finder = new ArrayList();
        is.findChildrenOfType(ASTPrimaryExpression.class, finder, true);
        return finder.size() > 1 && (nullStmt = this.findNonVariableStmt(varname, (ASTPrimaryExpression)finder.get(0), (ASTPrimaryExpression)finder.get(1))) != null && nullStmt.jjtGetNumChildren() == 1 && nullStmt.jjtGetChild(0) instanceof ASTPrimaryPrefix && (pp2 = (ASTPrimaryPrefix)nullStmt.jjtGetChild(0)).jjtGetNumChildren() == 1 && pp2.jjtGetChild(0) instanceof ASTLiteral && (lit = (ASTLiteral)pp2.jjtGetChild(0)).jjtGetNumChildren() == 1 && lit.jjtGetChild(0) instanceof ASTNullLiteral;
    }

    private ASTPrimaryExpression findNonVariableStmt(String variableName, ASTPrimaryExpression apeLeft, ASTPrimaryExpression apeRight) {
        if (this.matchName(apeLeft, variableName)) {
            return apeRight;
        }
        if (this.matchName(apeRight, variableName)) {
            return apeLeft;
        }
        return null;
    }

    private boolean matchName(ASTPrimaryExpression ape, String name) {
        ASTPrimaryPrefix pp;
        String name2;
        return ape.jjtGetNumChildren() == 1 && ape.jjtGetChild(0) instanceof ASTPrimaryPrefix && (name2 = this.getNameFromPrimaryPrefix(pp = (ASTPrimaryPrefix)ape.jjtGetChild(0))) != null && name2.equals(name);
    }

    private String getNameFromPrimaryPrefix(ASTPrimaryPrefix pp) {
        if (pp.jjtGetNumChildren() == 1 && pp.jjtGetChild(0) instanceof ASTName) {
            return ((ASTName)pp.jjtGetChild(0)).getImage();
        }
        return null;
    }
}

